/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.transformation;

import com.atlassian.braid.FieldTransformationContext;
import com.atlassian.braid.source.TrimFieldsSelection;
import com.atlassian.braid.source.VariableNamespacingGraphQLQueryVisitor;
import com.atlassian.braid.transformation.FieldWithCounter;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.Node;
import graphql.language.NodeTraverser;
import graphql.language.NodeVisitor;
import graphql.language.OperationDefinition;
import graphql.schema.DataFetchingEnvironment;
import java.util.List;
import java.util.function.Function;

class QueryTransformationUtils {
    QueryTransformationUtils() {
    }

    static OperationDefinition getOperationDefinition(DataFetchingEnvironment environment) {
        return environment.getExecutionContext().getOperationDefinition();
    }

    static FieldWithCounter cloneField(FieldTransformationContext fieldTransformationContext, List<Integer> usedCounterIds, DataFetchingEnvironment environment) {
        Field field = QueryTransformationUtils.cloneFieldBeingFetchedWithAlias(environment, QueryTransformationUtils.createFieldAlias(fieldTransformationContext.getCounter().incrementAndGet()));
        usedCounterIds.add(fieldTransformationContext.getCounter().get());
        List<FragmentDefinition> referencedFragments = TrimFieldsSelection.trimFieldSelection(fieldTransformationContext.getSchemaSource(), environment, (Node)field);
        return new FieldWithCounter(field, fieldTransformationContext.getCounter().get(), referencedFragments);
    }

    static void addFieldToQuery(FieldTransformationContext fieldTransformationContext, DataFetchingEnvironment environment, OperationDefinition operationDefinition, FieldWithCounter field) {
        VariableNamespacingGraphQLQueryVisitor variableNameSpacer = new VariableNamespacingGraphQLQueryVisitor(field.counter, operationDefinition, fieldTransformationContext.getVariables(), environment, fieldTransformationContext.getQueryOp());
        field.referencedFragments.forEach(arg_0 -> QueryTransformationUtils.lambda$addFieldToQuery$0((NodeVisitor)variableNameSpacer, fieldTransformationContext, arg_0));
        NodeTraverser nodeTraverser = new NodeTraverser();
        nodeTraverser.preOrder((NodeVisitor)variableNameSpacer, (Node)field.field);
        fieldTransformationContext.getQueryOp().getSelectionSet().getSelections().add(field.field);
    }

    private static Field cloneFieldBeingFetchedWithAlias(DataFetchingEnvironment environment, Function<Field, String> alias) {
        Field field = environment.getField().deepCopy();
        field.setAlias(alias.apply(field));
        return field;
    }

    private static Function<Field, String> createFieldAlias(int counter) {
        return field -> field.getName() + counter;
    }

    private static /* synthetic */ void lambda$addFieldToQuery$0(NodeVisitor variableNameSpacer, FieldTransformationContext fieldTransformationContext, FragmentDefinition d) {
        NodeTraverser nodeTraverser = new NodeTraverser();
        nodeTraverser.preOrder(variableNameSpacer, (Node)d);
        fieldTransformationContext.getDocument().getDefinitions().add(d);
    }
}

