/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.graphql.language;

import com.atlassian.braid.FieldMutationContext;
import com.atlassian.braid.graphql.language.RemoveUnknownFields;
import com.atlassian.braid.mutation.BraidSchemaSource;
import graphql.language.Document;
import graphql.language.FieldDefinition;
import graphql.language.FragmentDefinition;
import graphql.language.Node;
import graphql.language.ObjectTypeDefinition;
import graphql.language.OperationDefinition;
import graphql.language.Type;
import graphql.language.TypeName;
import graphql.language.VariableDefinition;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class DocumentMutations {
    public static void removeMissingFieldsIfBraidAndSourceTypeFieldsDiffer(FieldMutationContext context, GraphQLOutputType fieldOutputType) {
        BraidSchemaSource ds = new BraidSchemaSource(context.getSchemaSource());
        ds.getSchemaSource().getPrivateSchema().getType(ds.getSourceTypeName(fieldOutputType.getName())).ifPresent(type -> {
            if (fieldOutputType instanceof GraphQLObjectType && type instanceof ObjectTypeDefinition) {
                Set braidFieldNames = ((GraphQLObjectType)fieldOutputType).getFieldDefinitions().stream().map(GraphQLFieldDefinition::getName).collect(Collectors.toSet());
                Set<String> sourceFieldNames = ((ObjectTypeDefinition)type).getFieldDefinitions().stream().map(FieldDefinition::getName).collect(Collectors.toSet());
                if (!sourceFieldNames.equals(braidFieldNames)) {
                    context.addMissingFields(new RemoveUnknownFields(context.getSchemaSource().getPrivateSchema(), sourceFieldNames, type.getName(), (Node)context.getDocument()).execute());
                }
            }
        });
    }

    public static void unaliasTypes(BraidSchemaSource braidSchemaSource, Document document) {
        List newDefinitions = document.getDefinitions().stream().map(def -> {
            if (def instanceof OperationDefinition) {
                OperationDefinition op = (OperationDefinition)def;
                List newVariableDefinitions = op.getVariableDefinitions().stream().map(var -> new VariableDefinition(var.getName(), braidSchemaSource.unaliasType(var.getType()), var.getDefaultValue())).collect(Collectors.toList());
                return op.transform(builder -> builder.variableDefinitions(newVariableDefinitions));
            }
            if (def instanceof FragmentDefinition) {
                FragmentDefinition frag = (FragmentDefinition)def;
                return frag.transform(builder -> builder.typeCondition((TypeName)braidSchemaSource.unaliasType((Type)frag.getTypeCondition())));
            }
            return def;
        }).collect(Collectors.toList());
        document.getDefinitions().clear();
        document.getDefinitions().addAll(newDefinitions);
    }
}

