/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid;

import com.atlassian.braid.BraidTypeDefinition;
import com.atlassian.braid.FieldAlias;
import com.atlassian.braid.Link;
import com.atlassian.braid.SchemaNamespace;
import com.atlassian.braid.SchemaSource;
import com.atlassian.braid.TypeAlias;
import com.atlassian.braid.TypeUtils;
import graphql.language.InputValueDefinition;
import graphql.language.ListType;
import graphql.language.NonNullType;
import graphql.language.ObjectTypeDefinition;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BraidSchemaSource {
    private static final Logger log = LoggerFactory.getLogger(BraidSchemaSource.class);
    private final SchemaSource schemaSource;
    private final TypeDefinitionRegistry registry;
    private final ObjectTypeDefinition queryType;
    private final ObjectTypeDefinition mutationType;

    public BraidSchemaSource(SchemaSource schemaSource) {
        this.schemaSource = Objects.requireNonNull(schemaSource);
        this.registry = schemaSource.getSchema();
        this.queryType = TypeUtils.findQueryType(this.registry).orElse(null);
        this.mutationType = TypeUtils.findMutationType(this.registry).orElse(null);
    }

    public SchemaSource getSchemaSource() {
        return this.schemaSource;
    }

    SchemaNamespace getNamespace() {
        return this.schemaSource.getNamespace();
    }

    Optional<TypeAlias> getTypeAlias(String type) {
        return this.schemaSource.getTypeAliases().stream().filter(a -> a.getSourceName().equals(type)).findFirst();
    }

    public Optional<TypeAlias> getTypeAliasFromAlias(String type) {
        return this.schemaSource.getTypeAliases().stream().filter(a -> a.getBraidName().equals(type)).findFirst();
    }

    Optional<FieldAlias> getQueryFieldAlias(String type) {
        return this.getFieldAlias(this.schemaSource.getQueryFieldAliases(), type);
    }

    Optional<FieldAlias> getMutationFieldAliases(String type) {
        return this.getFieldAlias(this.schemaSource.getMutationFieldAliases(), type);
    }

    public String getLinkBraidSourceType(Link link) {
        return this.getQueryType().map(originalQueryType -> {
            if (originalQueryType.getName().equals(link.getSourceType())) {
                return "Query";
            }
            return link.getSourceType();
        }).orElse(link.getSourceType());
    }

    Collection<BraidTypeDefinition> getNonOperationTypes() {
        return this.registry.types().values().stream().filter(this::isNotOperationType).map(td -> new BraidTypeDefinition(this, (TypeDefinition)td)).collect(Collectors.toList());
    }

    boolean hasType(String type) {
        return this.registry.getType(type).isPresent();
    }

    Optional<ObjectTypeDefinition> getQueryType() {
        return Optional.ofNullable(this.queryType);
    }

    Optional<ObjectTypeDefinition> getMutationType() {
        return Optional.ofNullable(this.mutationType);
    }

    TypeDefinitionRegistry getTypeRegistry() {
        return this.registry;
    }

    public Type aliasType(Type type) {
        if (type instanceof TypeName) {
            String typeName = ((TypeName)type).getName();
            TypeAlias alias = this.getTypeAlias(typeName).orElse(TypeAlias.from(typeName, typeName));
            return new TypeName(alias.getBraidName());
        }
        if (type instanceof NonNullType) {
            return new NonNullType(this.aliasType(((NonNullType)type).getType()));
        }
        if (type instanceof ListType) {
            return new ListType(this.aliasType(((ListType)type).getType()));
        }
        log.error("Definition type : " + type + " not handled correctly for aliases.  Please raise an issue.");
        return type;
    }

    public Type unaliasType(Type type) {
        if (type instanceof TypeName) {
            String typeName = ((TypeName)type).getName();
            TypeAlias alias = this.getTypeAliasFromAlias(typeName).orElse(TypeAlias.from(typeName, typeName));
            return new TypeName(alias.getSourceName());
        }
        if (type instanceof NonNullType) {
            return new NonNullType(this.unaliasType(((NonNullType)type).getType()));
        }
        if (type instanceof ListType) {
            return new ListType(this.unaliasType(((ListType)type).getType()));
        }
        log.error("Definition type : " + type + " not handled correctly for aliases.  Please raise an issue.");
        return type;
    }

    List<InputValueDefinition> aliasInputValueDefinitions(List<InputValueDefinition> inputValueDefinitions) {
        return inputValueDefinitions.stream().map(input -> new InputValueDefinition(input.getName(), this.aliasType(input.getType()), input.getDefaultValue(), input.getDirectives())).collect(Collectors.toList());
    }

    private Optional<FieldAlias> getFieldAlias(List<FieldAlias> aliases, String type) {
        if (aliases.isEmpty()) {
            return Optional.of(FieldAlias.from(type, type));
        }
        return aliases.stream().filter(a -> a.getSourceName().equals(type)).findFirst();
    }

    private boolean isNotOperationType(TypeDefinition typeDefinition) {
        return !this.isOperationType(typeDefinition);
    }

    private boolean isOperationType(TypeDefinition typeDefinition) {
        Objects.requireNonNull(typeDefinition);
        return Objects.equals(this.queryType, typeDefinition) || Objects.equals(this.mutationType, typeDefinition);
    }
}

