package com.atlassian.braid;

import graphql.language.Field;
import graphql.schema.DataFetchingEnvironment;

import java.util.List;
import java.util.concurrent.CompletableFuture;

/**
 * A field mutation that will turn a field request into one more more fields to usually request from a remote source
 */
public interface FieldMutation {

    /**
     * Applies the mutation to an instance of a field in a query or mutation
     *
     * @param environment The environment for the field
     * @param context The context of the mutation
     * @return A list of fields to fetch from the target schema source
     */
    CompletableFuture<List<Field>> apply(DataFetchingEnvironment environment, FieldMutationContext context);
}
