/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.source;

import com.atlassian.braid.BatchLoaderFactory;
import com.atlassian.braid.BatchLoaderUtils;
import com.atlassian.braid.BraidContext;
import com.atlassian.braid.BraidContexts;
import com.atlassian.braid.Link;
import com.atlassian.braid.SchemaSource;
import com.atlassian.braid.TypeUtils;
import com.atlassian.braid.document.DocumentMapper;
import com.atlassian.braid.graphql.language.GraphQLNodes;
import com.atlassian.braid.java.util.BraidCollectors;
import com.atlassian.braid.java.util.BraidObjects;
import com.atlassian.braid.source.QueryExecutorSchemaSource;
import com.atlassian.braid.source.QueryFunction;
import com.atlassian.braid.source.RelativeGraphQLError;
import com.atlassian.braid.source.TrimFieldsSelection;
import com.atlassian.braid.source.VariableNamespacingGraphQLQueryVisitor;
import graphql.ExecutionInput;
import graphql.GraphQLError;
import graphql.execution.DataFetcherResult;
import graphql.language.Argument;
import graphql.language.Document;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.InputValueDefinition;
import graphql.language.Node;
import graphql.language.OperationDefinition;
import graphql.language.SelectionSet;
import graphql.language.Type;
import graphql.language.Value;
import graphql.language.VariableDefinition;
import graphql.language.VariableReference;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.dataloader.BatchLoader;

class QueryExecutor<C>
implements BatchLoaderFactory {
    private final QueryFunction<C> queryFunction;

    QueryExecutor(QueryFunction<C> queryFunction) {
        this.queryFunction = Objects.requireNonNull(queryFunction);
    }

    @Override
    public BatchLoader<DataFetchingEnvironment, DataFetcherResult<Object>> newBatchLoader(SchemaSource schemaSource, @Nullable Link link) {
        return new QueryExecutorBatchLoader((QueryExecutorSchemaSource)BraidObjects.cast(schemaSource), link, this.queryFunction);
    }

    private static DataFetcherResult<Map<FieldKey, Object>> resultWithMappedData(DocumentMapper.MappedDocument mappedDocument, DataFetcherResult<Map<FieldKey, Object>> result) {
        Function<Map<String, Object>, Map<String, Object>> mapper = mappedDocument.getResultMapper();
        HashMap data = new HashMap();
        ((Map)result.getData()).forEach((key, value) -> data.put(((FieldKey)key).value, value));
        Map<String, Object> newData = mapper.apply(data);
        HashMap resultData = new HashMap();
        newData.forEach((key, value) -> resultData.put(new FieldKey((String)key), value));
        return new DataFetcherResult(resultData, result.getErrors());
    }

    private static DataFetcherResult<Map<FieldKey, Object>> resultWithShortCircuitedData(Map<FieldKey, Object> shortCircuitedData, DataFetcherResult<Map<String, Object>> result) {
        HashMap<FieldKey, Object> data = new HashMap<FieldKey, Object>();
        Map<FieldKey, Object> dataByKey = ((Map)result.getData()).entrySet().stream().collect(BraidCollectors.nullSafeToMap(e -> new FieldKey((String)e.getKey()), Map.Entry::getValue));
        data.putAll(dataByKey);
        data.putAll(shortCircuitedData);
        return new DataFetcherResult(data, result.getErrors());
    }

    private static OperationDefinition getOperationDefinition(DataFetchingEnvironment environment) {
        return ((BraidContext)environment.getContext()).getExecutionContext().getOperationDefinition();
    }

    private static boolean isTargetIdNullAndCannotQueryLinkWithNull(Object targetId, Link link) {
        return targetId == null && !link.isNullable();
    }

    private static boolean isFieldQueryOnlySelectingVariable(Field field, Link link) {
        List selections = field.getSelectionSet().getSelections();
        return selections.stream().allMatch(s -> s instanceof Field) && selections.stream().map(BraidObjects::cast).allMatch(f -> f.getName().equals(link.getTargetVariableQueryField()));
    }

    private static VariableDefinition linkQueryVariableDefinition(Link link, String variableName, SchemaSource schemaSource) {
        return new VariableDefinition(variableName, QueryExecutor.findArgumentType(schemaSource, link));
    }

    private static List<Argument> linkQueryArgumentAsList(Link link, String variableName) {
        return Collections.singletonList(new Argument(link.getArgumentName(), (Value)new VariableReference(variableName)));
    }

    private static Function<Field, String> createFieldAlias(int counter) {
        return field -> field.getName() + counter;
    }

    private static OperationDefinition newQueryOperationDefinition(GraphQLOutputType fieldType, OperationDefinition.Operation operationType) {
        return new OperationDefinition(QueryExecutor.newBulkOperationName(fieldType), operationType, new SelectionSet());
    }

    private static String newBulkOperationName(GraphQLOutputType fieldType) {
        String type = fieldType instanceof GraphQLList ? ((GraphQLList)fieldType).getWrappedType().getName() : fieldType.getName();
        return "Bulk_" + type;
    }

    private static Field cloneFieldBeingFetchedWithAlias(DataFetchingEnvironment environment, Function<Field, String> alias) {
        Field field = environment.getField().deepCopy();
        field.setAlias(alias.apply(field));
        return field;
    }

    private static ExecutionInput executeBatchQuery(Document doc, String operationName, Map<String, Object> variables) {
        return ExecutionInput.newExecutionInput().query(GraphQLNodes.printNode((Node)doc)).operationName(operationName).variables(variables).build();
    }

    private static List<DataFetcherResult<Object>> transformBatchResultIntoResultList(List<DataFetchingEnvironment> environments, Map<DataFetchingEnvironment, List<FieldKey>> clonedFields, DataFetcherResult<Map<FieldKey, Object>> result) {
        ArrayList<DataFetcherResult<Object>> queryResults = new ArrayList<DataFetcherResult<Object>>();
        Map data = (Map)result.getData();
        for (DataFetchingEnvironment environment : environments) {
            List<FieldKey> fields = clonedFields.get(environment);
            if (!fields.isEmpty()) {
                FieldKey field = fields.get(0);
                Object fieldData = BraidObjects.cast(data.getOrDefault(field, null));
                if (environment.getFieldType() instanceof GraphQLList && !(fieldData instanceof List)) {
                    fieldData = fields.stream().map(f -> BraidObjects.cast(data.getOrDefault(f, null))).collect(Collectors.toList());
                } else if (fields.size() > 1) {
                    throw new IllegalStateException("Can't query for multiple fields if the target type isn't a list");
                }
                queryResults.add((DataFetcherResult<Object>)new DataFetcherResult(fieldData, QueryExecutor.buildDataFetcherResultErrors(result, fields)));
                continue;
            }
            if (environment.getSource() instanceof Map && ((Map)environment.getSource()).get(environment.getFieldDefinition().getName()) instanceof List) {
                queryResults.add((DataFetcherResult<Object>)new DataFetcherResult(Collections.emptyList(), QueryExecutor.buildDataFetcherResultErrors(result, fields)));
                continue;
            }
            queryResults.add((DataFetcherResult<Object>)new DataFetcherResult(null, QueryExecutor.buildDataFetcherResultErrors(result, fields)));
        }
        return queryResults;
    }

    private static List<GraphQLError> buildDataFetcherResultErrors(DataFetcherResult<Map<FieldKey, Object>> result, List<FieldKey> fields) {
        return result.getErrors().stream().filter(e -> e.getPath() == null || e.getPath().isEmpty() || fields.contains(new FieldKey(String.valueOf(e.getPath().get(0))))).map(RelativeGraphQLError::new).collect(Collectors.toList());
    }

    private static Type findArgumentType(SchemaSource schemaSource, Link link) {
        return TypeUtils.findQueryFieldDefinitions(schemaSource.getPrivateSchema()).orElseThrow(IllegalStateException::new).stream().filter(f -> f.getName().equals(link.getTargetQueryField())).findFirst().map(f -> f.getInputValueDefinitions().stream().filter(iv -> iv.getName().equals(link.getArgumentName())).findFirst().map(InputValueDefinition::getType).orElseThrow(IllegalArgumentException::new)).orElseThrow(IllegalArgumentException::new);
    }

    private static class FieldKey {
        private final String value;

        private FieldKey(String value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldKey fieldKey = (FieldKey)o;
            return Objects.equals(this.value, fieldKey.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }

    private static class FieldWithCounter {
        private final Field field;
        private final int counter;
        private final List<FragmentDefinition> referencedFragments;

        private FieldWithCounter(Field field, int counter, List<FragmentDefinition> referencedFragments) {
            this.field = field;
            this.counter = counter;
            this.referencedFragments = referencedFragments;
        }
    }

    private static class QueryExecutorBatchLoader<C>
    implements BatchLoader<DataFetchingEnvironment, DataFetcherResult<Object>> {
        private final QueryExecutorSchemaSource schemaSource;
        @Nullable
        private final Link link;
        private final QueryFunction<C> queryFunction;

        private QueryExecutorBatchLoader(QueryExecutorSchemaSource schemaSource, @Nullable Link link, QueryFunction<C> queryFunction) {
            this.schemaSource = Objects.requireNonNull(schemaSource);
            this.link = link;
            this.queryFunction = Objects.requireNonNull(queryFunction);
        }

        public CompletionStage<List<DataFetcherResult<Object>>> load(List<DataFetchingEnvironment> environments) {
            C context = QueryExecutorBatchLoader.checkAndGetContext(environments);
            OperationDefinition.Operation operationType = QueryExecutorBatchLoader.checkAndGetOperationType(environments).orElse(OperationDefinition.Operation.QUERY);
            GraphQLOutputType fieldOutputType = QueryExecutorBatchLoader.checkAndGetFieldOutputType(environments);
            Document doc = new Document();
            OperationDefinition queryOp = QueryExecutor.newQueryOperationDefinition(fieldOutputType, operationType);
            doc.getDefinitions().add(queryOp);
            HashMap variables = new HashMap();
            HashMap clonedFields = new HashMap();
            AtomicInteger counter = new AtomicInteger(99);
            HashMap shortCircuitedData = new HashMap();
            CompletableFuture[] fieldFutures = (CompletableFuture[])environments.stream().map(env -> this.environmentToFields((DataFetchingEnvironment)env, queryOp, variables, doc, counter, shortCircuitedData).thenAccept(fields -> clonedFields.put(env, fields.stream().map(Field::getAlias).map(x$0 -> new FieldKey((String)x$0)).collect(Collectors.toList())))).toArray(CompletableFuture[]::new);
            return CompletableFuture.allOf(fieldFutures).thenCompose(__ -> {
                DocumentMapper.MappedDocument mappedDocument = (DocumentMapper.MappedDocument)this.schemaSource.getDocumentMapper().apply(doc);
                return ((CompletableFuture)((CompletableFuture)this.executeQuery(context, mappedDocument.getDocument(), queryOp, variables).thenApply(result -> QueryExecutor.resultWithShortCircuitedData(shortCircuitedData, (DataFetcherResult<Map<String, Object>>)result))).thenApply(result -> QueryExecutor.resultWithMappedData(mappedDocument, (DataFetcherResult<Map<FieldKey, Object>>)result))).thenApply(result -> QueryExecutor.transformBatchResultIntoResultList(environments, clonedFields, (DataFetcherResult<Map<FieldKey, Object>>)result));
            });
        }

        private CompletableFuture<List<Field>> environmentToFields(DataFetchingEnvironment environment, OperationDefinition queryOp, Map<String, Object> variables, Document doc, AtomicInteger counter, Map<FieldKey, Object> shortCircuitedData) {
            OperationDefinition operationDefinition = QueryExecutor.getOperationDefinition(environment);
            if (this.link != null) {
                ArrayList usedCounterIds = new ArrayList();
                return BatchLoaderUtils.getTargetIdsFromEnvironment(this.link, environment).thenApply(targetIds -> {
                    ArrayList<Field> fields = new ArrayList<Field>();
                    Field cloneOfCurrentField = environment.getField().deepCopy();
                    boolean fieldQueryOnlySelectingVariable = QueryExecutor.isFieldQueryOnlySelectingVariable(cloneOfCurrentField, this.link);
                    for (final Object targetId : targetIds) {
                        FieldWithCounter field = this.cloneField(this.schemaSource, counter, usedCounterIds, environment);
                        if (QueryExecutor.isTargetIdNullAndCannotQueryLinkWithNull(targetId, this.link)) {
                            shortCircuitedData.put(new FieldKey(field.field.getAlias()), null);
                        } else if (fieldQueryOnlySelectingVariable) {
                            shortCircuitedData.put(new FieldKey(field.field.getAlias()), new HashMap<String, Object>(){
                                {
                                    this.put(link.getTargetVariableQueryField(), targetId);
                                }
                            });
                        } else {
                            this.addQueryVariable(queryOp, variables, counter, targetId, field);
                            this.addFieldToQuery(doc, queryOp, variables, environment, operationDefinition, field);
                        }
                        fields.add(field.field);
                    }
                    return fields;
                });
            }
            FieldWithCounter field = this.cloneField(this.schemaSource, counter, new ArrayList<Integer>(), environment);
            this.addFieldToQuery(doc, queryOp, variables, environment, operationDefinition, field);
            return CompletableFuture.completedFuture(Collections.singletonList(field.field));
        }

        private static <C> C checkAndGetContext(Collection<DataFetchingEnvironment> environments) {
            return (C)environments.stream().map(BraidContexts::get).collect(BraidCollectors.singleton(BraidCollectors.SingletonCharacteristics.ALLOW_MULTIPLE_OCCURRENCES));
        }

        private static Optional<OperationDefinition.Operation> checkAndGetOperationType(Collection<DataFetchingEnvironment> environments) {
            return (Optional)environments.stream().map(QueryExecutorBatchLoader::getOperationType).collect(BraidCollectors.singleton(BraidCollectors.SingletonCharacteristics.ALLOW_MULTIPLE_OCCURRENCES));
        }

        private static Optional<OperationDefinition.Operation> getOperationType(DataFetchingEnvironment env) {
            GraphQLType graphQLType = env.getParentType();
            GraphQLSchema graphQLSchema = env.getGraphQLSchema();
            if (Objects.equals(graphQLSchema.getQueryType(), graphQLType)) {
                return Optional.of(OperationDefinition.Operation.QUERY);
            }
            if (Objects.equals(graphQLSchema.getMutationType(), graphQLType)) {
                return Optional.of(OperationDefinition.Operation.MUTATION);
            }
            return Optional.empty();
        }

        private static GraphQLOutputType checkAndGetFieldOutputType(List<DataFetchingEnvironment> environments) {
            return (GraphQLOutputType)environments.stream().map(DataFetchingEnvironment::getFieldDefinition).map(GraphQLFieldDefinition::getType).collect(BraidCollectors.singleton(BraidCollectors.SingletonCharacteristics.ALLOW_MULTIPLE_OCCURRENCES));
        }

        private void addFieldToQuery(Document doc, OperationDefinition queryOp, Map<String, Object> variables, DataFetchingEnvironment environment, OperationDefinition operationDefinition, FieldWithCounter field) {
            VariableNamespacingGraphQLQueryVisitor variableNameSpacer = new VariableNamespacingGraphQLQueryVisitor(field.counter, operationDefinition, variables, environment, queryOp);
            field.referencedFragments.forEach(d -> {
                variableNameSpacer.visit((Node)d);
                doc.getDefinitions().add(d);
            });
            variableNameSpacer.visit((Node)field.field);
            queryOp.getSelectionSet().getSelections().add(field.field);
        }

        private CompletableFuture<DataFetcherResult<Map<String, Object>>> executeQuery(C context, Document doc, OperationDefinition queryOp, Map<String, Object> variables) {
            CompletableFuture<DataFetcherResult<Map<String, Object>>> queryResult;
            if (queryOp.getSelectionSet().getSelections().isEmpty()) {
                queryResult = CompletableFuture.completedFuture(new DataFetcherResult(Collections.emptyMap(), Collections.emptyList()));
            } else {
                ExecutionInput input = QueryExecutor.executeBatchQuery(doc, queryOp.getName(), variables);
                queryResult = this.queryFunction.query(input, context);
            }
            return queryResult;
        }

        private void addQueryVariable(OperationDefinition queryOp, Map<String, Object> variables, AtomicInteger counter, Object targetId, FieldWithCounter field) {
            String variableName = this.link.getArgumentName() + counter;
            field.field.setName(this.link.getTargetQueryField());
            field.field.setArguments(QueryExecutor.linkQueryArgumentAsList(this.link, variableName));
            queryOp.getVariableDefinitions().add(QueryExecutor.linkQueryVariableDefinition(this.link, variableName, this.schemaSource));
            variables.put(variableName, targetId);
        }

        private FieldWithCounter cloneField(SchemaSource schemaSource, AtomicInteger counter, List<Integer> usedCounterIds, DataFetchingEnvironment environment) {
            Field field = QueryExecutor.cloneFieldBeingFetchedWithAlias(environment, QueryExecutor.createFieldAlias(counter.incrementAndGet()));
            usedCounterIds.add(counter.get());
            List<FragmentDefinition> referencedFragments = TrimFieldsSelection.trimFieldSelection(schemaSource, environment, (Node)field);
            return new FieldWithCounter(field, counter.get(), referencedFragments);
        }
    }
}

