/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.source;

import com.atlassian.braid.Link;
import com.atlassian.braid.SchemaNamespace;
import com.atlassian.braid.SchemaSource;
import com.atlassian.braid.document.DocumentMapperFactory;
import com.atlassian.braid.document.DocumentMappers;
import com.atlassian.braid.java.util.BraidObjects;
import com.atlassian.braid.source.BaseQueryExecutorSchemaSource;
import com.atlassian.braid.source.ForwardingSchemaSource;
import com.atlassian.braid.source.GraphQLRemoteRetriever;
import com.atlassian.braid.source.MapGraphQLError;
import com.atlassian.braid.source.QueryExecutorSchemaSource;
import com.atlassian.braid.source.SchemaUtils;
import graphql.ExecutionInput;
import graphql.execution.DataFetcherResult;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class GraphQLRemoteSchemaSource<C>
extends ForwardingSchemaSource
implements QueryExecutorSchemaSource {
    private final BaseQueryExecutorSchemaSource<C> delegate;
    private final GraphQLRemoteRetriever<C> graphQLRemoteRetriever;

    public GraphQLRemoteSchemaSource(SchemaNamespace namespace, Supplier<Reader> schemaProvider, GraphQLRemoteRetriever<C> graphQLRemoteRetriever, List<Link> links, String ... topLevelFields) {
        this(namespace, schemaProvider, graphQLRemoteRetriever, links, DocumentMappers.identity(), topLevelFields);
    }

    public GraphQLRemoteSchemaSource(SchemaNamespace namespace, Supplier<Reader> schemaProvider, GraphQLRemoteRetriever<C> graphQLRemoteRetriever, List<Link> links, DocumentMapperFactory documentMapperFactory, String ... topLevelFields) {
        this(namespace, SchemaUtils.loadPublicSchema(schemaProvider, topLevelFields), SchemaUtils.loadSchema(schemaProvider), graphQLRemoteRetriever, links, documentMapperFactory);
    }

    public GraphQLRemoteSchemaSource(SchemaNamespace namespace, TypeDefinitionRegistry publicSchema, TypeDefinitionRegistry privateSchema, GraphQLRemoteRetriever<C> graphQLRemoteRetriever, List<Link> links, DocumentMapperFactory documentMapperFactory) {
        this.graphQLRemoteRetriever = Objects.requireNonNull(graphQLRemoteRetriever);
        this.delegate = new BaseQueryExecutorSchemaSource<Object>(namespace, publicSchema, privateSchema, links, documentMapperFactory, this::query);
    }

    @Override
    protected SchemaSource getDelegate() {
        return this.delegate;
    }

    public CompletableFuture<DataFetcherResult<Map<String, Object>>> query(ExecutionInput query, C context) {
        return this.graphQLRemoteRetriever.queryGraphQL(query, context).thenApply(response -> {
            Map data = Optional.ofNullable(response.get("data")).map(BraidObjects::cast).orElse(Collections.emptyMap());
            List errorsMap = Optional.ofNullable(response.get("errors")).map(BraidObjects::cast).orElse(Collections.emptyList());
            List errors = errorsMap.stream().map(val -> Optional.ofNullable(val).map(BraidObjects::cast).orElseThrow(IllegalArgumentException::new)).map(MapGraphQLError::new).collect(Collectors.toList());
            return new DataFetcherResult(data, errors);
        });
    }
}

