/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.document;

import com.atlassian.braid.document.CopyFieldOperation;
import com.atlassian.braid.document.DocumentMapperException;
import com.atlassian.braid.document.DocumentMapperPredicates;
import com.atlassian.braid.document.PutFieldOperation;
import com.atlassian.braid.document.SelectionOperation;
import com.atlassian.braid.document.TypeMapper;
import com.atlassian.braid.document.TypeMapperImpl;
import com.atlassian.braid.java.util.BraidMaps;
import com.atlassian.braid.java.util.BraidObjects;
import com.atlassian.braid.yaml.BraidYaml;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;

final class YamlTypeMappers {
    private YamlTypeMappers() {
    }

    static List<TypeMapper> from(List<Map<String, Object>> yamlAsList) {
        return yamlAsList.stream().map(YamlTypeMappers::toYamlTypeMapper).map(YamlTypeMappers::fromYamlTypeMapper).collect(Collectors.toList());
    }

    private static YamlTypeMapper toYamlTypeMapper(Map<String, Object> yaml) {
        String type = BraidYaml.getStringValue(yaml, "type", DocumentMapperException::new);
        List<YamlFieldOperation> operations = BraidMaps.get(yaml, "operations").map(BraidObjects::cast).map(YamlTypeMappers::toYamlFieldOperations).orElse(Collections.emptyList());
        return new YamlTypeMapper(type, operations);
    }

    private static List<YamlFieldOperation> toYamlFieldOperations(List<Map<String, Object>> yaml) {
        return yaml.stream().map(YamlTypeMappers::toYamlFieldOperation).collect(Collectors.toList());
    }

    private static YamlFieldOperation toYamlFieldOperation(Map<String, Object> yaml) {
        if (yaml.size() == 1) {
            Map.Entry<String, Object> operationAsEntry = BraidMaps.firstEntry(yaml);
            assert (operationAsEntry != null);
            return new YamlFieldOperation(operationAsEntry.getKey(), (String)BraidObjects.cast(operationAsEntry.getValue()), Collections.emptyMap());
        }
        return new YamlFieldOperation(BraidYaml.getKey(yaml, DocumentMapperException::new), BraidYaml.getOperationName(yaml, DocumentMapperException::new), yaml);
    }

    private static TypeMapper fromYamlTypeMapper(YamlTypeMapper yamlTypeMapper) {
        return new TypeMapperImpl(DocumentMapperPredicates.typeNamed(yamlTypeMapper.typeName), YamlTypeMappers.fromYamlFieldOperations(yamlTypeMapper.operations));
    }

    private static List<SelectionOperation> fromYamlFieldOperations(List<YamlFieldOperation> operations) {
        return operations.stream().map(YamlFieldOperation::get).collect(Collectors.toList());
    }

    private static class YamlFieldOperation
    implements Supplier<SelectionOperation> {
        private final String key;
        private final String name;
        private final Map<String, Object> props;

        YamlFieldOperation(String key, String name, Map<String, Object> props) {
            this.key = key;
            this.name = name;
            this.props = props;
        }

        private YamlFieldOperationType getOperation() {
            try {
                return YamlFieldOperationType.valueOf(this.name.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new DocumentMapperException("Could not find operation with name '%s'", this.name);
            }
        }

        @Override
        public SelectionOperation get() {
            return this.getOperation().apply(this.key, this.props);
        }
    }

    private static class YamlTypeMapper {
        private final String typeName;
        private final List<YamlFieldOperation> operations;

        YamlTypeMapper(String typeName, List<YamlFieldOperation> operations) {
            this.typeName = typeName;
            this.operations = operations;
        }
    }

    private static enum YamlFieldOperationType implements BiFunction<String, Map<String, Object>, SelectionOperation>
    {
        COPY((key, props) -> new CopyFieldOperation((String)key, BraidYaml.getTargetKey(props, key))),
        PUT((key, props) -> new PutFieldOperation((String)key, (String)BraidObjects.cast(props.get("value"))));

        private final BiFunction<String, Map<String, Object>, SelectionOperation> getOperation;

        private YamlFieldOperationType(BiFunction<String, Map<String, Object>, SelectionOperation> getOperation) {
            this.getOperation = getOperation;
        }

        @Override
        public SelectionOperation apply(String key, Map<String, Object> props) {
            return this.getOperation.apply(key, props);
        }
    }
}

