/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.java.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collector;

public final class BraidCollectors {
    private BraidCollectors() {
    }

    public static <T> Collector<T, ?, T> singleton() {
        return BraidCollectors.singleton(new SingletonCharacteristics[0]);
    }

    public static <T> Collector<T, ?, T> singleton(SingletonCharacteristics ... characteristics) {
        return BraidCollectors.singleton("Expected only one element", new Object[0], characteristics);
    }

    public static <T> Collector<T, ?, T> singleton(String msg, Object[] args, SingletonCharacteristics ... characteristics) {
        return Collector.of(Arrays.asList(characteristics).contains((Object)SingletonCharacteristics.ALLOW_MULTIPLE_OCCURRENCES) ? HashSet::new : ArrayList::new, Collection::add, (left, right) -> {
            left.addAll(right);
            return left;
        }, collection -> {
            if (collection.size() != 1) {
                throw new IllegalStateException(String.format(msg, args));
            }
            return collection.iterator().next();
        }, new Collector.Characteristics[0]);
    }

    public static <T, K, V> Collector<T, Map<K, V>, Map<K, V>> nullSafeToMap(Function<T, K> keyMapper, Function<T, V> valueMapper) {
        return Collector.of(HashMap::new, BraidCollectors.mergeEntry(keyMapper, valueMapper), BraidCollectors::mergeMaps, new Collector.Characteristics[0]);
    }

    private static <K, V> Map<K, V> mergeMaps(Map<K, V> map1, Map<K, V> map2) {
        HashMap<K, V> newMap = new HashMap<K, V>(map1);
        map2.forEach(BraidCollectors.mergeEntry(newMap));
        return newMap;
    }

    private static <T, K, V> BiConsumer<Map<K, V>, T> mergeEntry(Function<T, K> key, Function<T, V> value) {
        return (map, t) -> BraidCollectors.mergeEntry(map, key.apply(t), value.apply(t));
    }

    private static <K, V> BiConsumer<K, V> mergeEntry(Map<K, V> map) {
        return (k, v) -> BraidCollectors.mergeEntry(map, k, v);
    }

    private static <K, V> void mergeEntry(Map<K, V> map, K key, V value) {
        V existingValue = map.putIfAbsent(key, value);
        if (existingValue != null && !Objects.equals(value, existingValue)) {
            throw new IllegalStateException(String.format("Error merging {%s:%s} in map, existing value is: %s", key, value, existingValue));
        }
    }

    public static enum SingletonCharacteristics {
        ALLOW_MULTIPLE_OCCURRENCES;

    }
}

