/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.who;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.internal.ssh.who.WhoAmISshCommand;
import com.atlassian.bitbucket.ssh.command.SshCommand;
import com.atlassian.bitbucket.ssh.command.SshCommandFactory;
import com.google.common.collect.ImmutableSet;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;

public class WhoAmISshCommandFactory
implements SshCommandFactory {
    private static final Set<String> SUPPORTED_COMMANDS = ImmutableSet.of((Object)"who am i", (Object)"whoami", (Object)"who");
    private final AuthenticationContext authenticationContext;

    public WhoAmISshCommandFactory(AuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    @Nonnull
    public Optional<SshCommand> create(@Nonnull String command, @Nonnull InputStream stdin, @Nonnull OutputStream stdout, @Nonnull OutputStream stderr) {
        if (this.supports(command)) {
            return Optional.of(new WhoAmISshCommand(this.authenticationContext, stdout));
        }
        return Optional.empty();
    }

    public boolean supports(@Nonnull String command) {
        return SUPPORTED_COMMANDS.contains(command.toLowerCase(Locale.ROOT));
    }
}

