/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.utils;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.Date;
import org.apache.commons.lang3.time.FastDateFormat;

public class TimestampOutputStream
extends FilterOutputStream {
    private final FastDateFormat formatter = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss,S");
    private boolean first = true;

    protected TimestampOutputStream(String filename) throws FileNotFoundException {
        super(new FileOutputStream(filename));
    }

    @Override
    public void write(int b) throws IOException {
        if (this.first) {
            this.first = false;
            this.logDate();
            this.out.write(b);
        } else if (b == 10) {
            this.out.write(b);
            this.logDate();
        } else {
            this.out.write(b);
        }
    }

    @Override
    public void close() throws IOException {
        this.logDate();
        this.out.write("Closing stream".getBytes());
        this.out.flush();
        this.out.close();
    }

    private void logDate() throws IOException {
        Date date = new Date();
        String s = this.formatter.format(date);
        this.out.write(s.getBytes());
        this.out.write("> ".getBytes());
    }
}

