/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.servlet;

import com.atlassian.bitbucket.internal.ssh.fragments.SshKeysContextProvider;
import com.atlassian.bitbucket.internal.ssh.servlet.ResponseRenderer;
import com.atlassian.bitbucket.internal.ssh.servlet.SshKeysRequest;
import com.atlassian.bitbucket.internal.ssh.servlet.SshKeysRequestHandler;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

class ViewKeysRequestHandler
implements SshKeysRequestHandler {
    @VisibleForTesting
    static final String CONTEXT_VIEW_SSH_KEYS = "bitbucket.page.view.ssh.keys";
    static final String TEMPLATE_VIEW_ACCOUNT_KEYS = "bitbucket.internal.page.ssh.keys.viewAccountSshKeys";
    static final String TEMPLATE_VIEW_PROJECT_KEYS = "bitbucket.internal.page.ssh.keys.viewProjectKeyAccesses";
    static final String TEMPLATE_VIEW_REPO_KEYS = "bitbucket.internal.page.ssh.keys.viewRepoKeyAccesses";
    private static final Map<String, Object> EMPTY_CONTEXT = Collections.emptyMap();
    private final PageBuilderService pageBuilderService;
    private final SshKeysContextProvider sshKeysContextProvider;
    private final ResponseRenderer responseRenderer;

    public ViewKeysRequestHandler(PageBuilderService pageBuilderService, SshKeysContextProvider sshKeysContextProvider, ResponseRenderer responseRenderer) {
        this.pageBuilderService = pageBuilderService;
        this.sshKeysContextProvider = sshKeysContextProvider;
        this.responseRenderer = responseRenderer;
    }

    @Override
    public void get(SshKeysRequest request, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Map<String, Object> context;
        String templateName;
        if (request.getProject() != null) {
            templateName = TEMPLATE_VIEW_PROJECT_KEYS;
            context = this.sshKeysContextProvider.createKeyTableContext(EMPTY_CONTEXT, request.getProject());
        } else if (request.getRepository() != null) {
            templateName = TEMPLATE_VIEW_REPO_KEYS;
            context = this.sshKeysContextProvider.createKeyTableContext(EMPTY_CONTEXT, request.getRepository());
        } else if (request.getUser() != null) {
            templateName = TEMPLATE_VIEW_ACCOUNT_KEYS;
            context = this.sshKeysContextProvider.createKeyTableContext(EMPTY_CONTEXT, request.getUser());
        } else {
            resp.sendError(404);
            return;
        }
        this.pageBuilderService.assembler().resources().requireContext(CONTEXT_VIEW_SSH_KEYS);
        this.responseRenderer.renderToResponse(req, resp, "com.atlassian.stash.ssh-plugin:ssh-serverside-soy", templateName, context);
    }

    @Override
    public void post(SshKeysRequest request, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        throw new ServletException("POST is not supported by this servlet");
    }
}

