/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.servlet;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.RequestCanceledException;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.internal.ssh.dao.SshConfigurationDao;
import com.atlassian.bitbucket.internal.ssh.servlet.ResponseRenderer;
import com.atlassian.bitbucket.internal.ssh.servlet.SshKeyForm;
import com.atlassian.bitbucket.internal.ssh.servlet.SshKeysRequest;
import com.atlassian.bitbucket.internal.ssh.servlet.SshKeysRequestHandler;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.ssh.DuplicatePublicKeyException;
import com.atlassian.bitbucket.ssh.SetSshAccessKeyRequest;
import com.atlassian.bitbucket.ssh.SshAccessKeyService;
import com.atlassian.bitbucket.ssh.SshKeyService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.UrlUtils;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.apache.commons.lang3.StringUtils;

class AddKeyRequestHandler
implements SshKeysRequestHandler {
    @VisibleForTesting
    static final String TEMPLATE_ADD_KEY = "bitbucket.internal.page.ssh.keys.addKey";
    static final String KEY_CANCEL_URL = "cancelUrl";
    static final String KEY_ASK_PERMISSION = "askPermission";
    static final String KEY_REPOSITORY = "repository";
    static final String KEY_PROJECT = "project";
    static final String KEY_USER = "user";
    private final SshAccessKeyService accessKeyService;
    private final NavBuilder navBuilder;
    private final ResponseRenderer responseRenderer;
    private final SshConfigurationDao sshConfig;
    private final SshKeyService sshKeyService;

    public AddKeyRequestHandler(NavBuilder navBuilder, ResponseRenderer responseRenderer, SshConfigurationDao sshConfig, SshAccessKeyService accessKeyService, SshKeyService sshKeyService) {
        this.accessKeyService = accessKeyService;
        this.navBuilder = navBuilder;
        this.responseRenderer = responseRenderer;
        this.sshConfig = sshConfig;
        this.sshKeyService = sshKeyService;
    }

    @Override
    public void get(SshKeysRequest request, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.isDisabled(request)) {
            resp.sendError(409);
            return;
        }
        Map<String, Object> model = this.createModel(request);
        this.responseRenderer.renderToResponse(req, resp, "com.atlassian.stash.ssh-plugin:ssh-serverside-soy", TEMPLATE_ADD_KEY, model);
    }

    @Override
    public void post(SshKeysRequest request, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.isDisabled(request)) {
            resp.sendError(409);
            return;
        }
        try {
            String redirectUrl;
            Permission permission;
            SshKeyForm keyForm = request.getForm();
            Project project = request.getProject();
            Repository repository = request.getRepository();
            ApplicationUser user = request.getUser();
            if (project != null) {
                permission = request.getForm().isReadOnly() ? Permission.PROJECT_READ : Permission.PROJECT_WRITE;
                this.accessKeyService.set(new SetSshAccessKeyRequest.Builder().projectAccess(project, permission).key(keyForm.getText(), keyForm.getLabel()).build());
                redirectUrl = this.getProjectAccessKeysUrl(project);
            } else if (repository != null) {
                permission = request.getForm().isReadOnly() ? Permission.REPO_READ : Permission.REPO_WRITE;
                this.accessKeyService.set(new SetSshAccessKeyRequest.Builder().repositoryAccess(repository, permission).key(keyForm.getText(), keyForm.getLabel()).build());
                redirectUrl = this.getRepositoryAccessKeysUrl(repository);
            } else if (user != null) {
                this.sshKeyService.addForUser(user, keyForm.getText(), keyForm.getLabel());
                redirectUrl = this.getUserKeysUrl(user, request.isAdmin());
            } else {
                throw new IllegalStateException("No project, repository or user identified by SshKeysRequest");
            }
            String nextUrl = request.getNextUrl();
            if (!StringUtils.isEmpty((CharSequence)nextUrl)) {
                redirectUrl = nextUrl;
            }
            resp.sendRedirect(UrlUtils.safeUrlForRedirect((String)redirectUrl, (String)this.navBuilder.buildAbsolute(), (String)this.navBuilder.buildAbsolute()));
        }
        catch (ConstraintViolationException e) {
            this.renderValidationErrors(request, req, resp, e.getConstraintViolations(), new String[0]);
        }
        catch (DuplicatePublicKeyException e) {
            this.renderValidationErrors(request, req, resp, null, e.getLocalizedMessage());
        }
        catch (NoSuchEntityException e) {
            resp.sendError(404, e.getLocalizedMessage());
        }
        catch (AuthorisationException e) {
            resp.sendError(401, e.getLocalizedMessage());
        }
        catch (RequestCanceledException e) {
            String[] cancelMessages = (String[])e.getCancelMessages().stream().map(KeyedMessage::getLocalisedMessage).toArray(String[]::new);
            this.renderValidationErrors(request, req, resp, null, cancelMessages);
        }
    }

    private boolean isDisabled(SshKeysRequest request) throws IOException {
        return request.isForAccessKeys() && (!this.sshConfig.get().isEnabled() || !this.sshConfig.get().isAccessKeysEnabled());
    }

    private Map<String, Object> createModel(SshKeysRequest request) {
        Project project;
        HashMap<String, Object> model = new HashMap<String, Object>();
        SshKeyForm form = request.getForm();
        if (form != null && !form.isEmpty()) {
            model.put("form", form);
        }
        if ((project = request.getProject()) != null) {
            model.put(KEY_PROJECT, project);
            model.put(KEY_ASK_PERMISSION, true);
            model.put(KEY_CANCEL_URL, this.getProjectAccessKeysUrl(project));
            return model;
        }
        Repository repository = request.getRepository();
        if (repository != null) {
            model.put(KEY_REPOSITORY, repository);
            model.put(KEY_ASK_PERMISSION, true);
            model.put(KEY_CANCEL_URL, this.getRepositoryAccessKeysUrl(repository));
            return model;
        }
        ApplicationUser user = request.getUser();
        if (user != null) {
            model.put(KEY_USER, user);
            model.put(KEY_ASK_PERMISSION, false);
            model.put(KEY_CANCEL_URL, this.getUserKeysUrl(user, request.isAdmin()));
            return model;
        }
        throw new IllegalStateException("No project, repository or user identified by SshKeysRequest");
    }

    private String getUserKeysUrl(ApplicationUser user, boolean admin) {
        if (admin) {
            return this.navBuilder.admin().users().view(user.getName()).listSshKeys().buildRelative();
        }
        return this.navBuilder.pluginServlets().path(new String[]{"ssh", "account", "keys"}).buildRelative();
    }

    private String getProjectAccessKeysUrl(Project project) {
        return this.navBuilder.pluginServlets().path(new String[]{"ssh", "projects", project.getKey(), "keys"}).buildRelative();
    }

    private String getRepositoryAccessKeysUrl(Repository repository) {
        return this.navBuilder.pluginServlets().path(new String[]{"ssh", "projects", repository.getProject().getKey(), "repos", repository.getSlug(), "keys"}).buildRelative();
    }

    private void renderValidationErrors(SshKeysRequest request, HttpServletRequest req, HttpServletResponse resp, Set<ConstraintViolation<?>> constraintViolations, String ... errorMessages) throws ServletException, IOException {
        Map<String, Object> model = this.createModel(request);
        if (constraintViolations != null) {
            model.put("fieldErrors", this.toFieldErrors(constraintViolations));
        }
        if (errorMessages != null) {
            model.put("formErrors", Arrays.asList(errorMessages));
        }
        this.responseRenderer.renderToResponse(req, resp, "com.atlassian.stash.ssh-plugin:ssh-serverside-soy", TEMPLATE_ADD_KEY, model);
    }

    private Map<String, List<String>> toFieldErrors(Set<ConstraintViolation<?>> constraintViolations) {
        if (constraintViolations == null) {
            return null;
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (ConstraintViolation<?> constraintViolation : constraintViolations) {
            String key = constraintViolation.getPropertyPath().toString();
            if (!map.containsKey(key)) {
                map.put(key, new ArrayList());
            }
            ((List)map.get(key)).add(constraintViolation.getMessage());
        }
        return map;
    }
}

