/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.service;

import com.atlassian.activeobjects.spi.TransactionSynchronisationManager;
import com.atlassian.bitbucket.internal.ssh.dao.SshConfigurationDao;
import com.atlassian.bitbucket.internal.ssh.service.SshConfigurationRefreshEvent;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.ssh.SimpleSshConfiguration;
import com.atlassian.bitbucket.ssh.SshConfiguration;
import com.atlassian.bitbucket.ssh.SshConfigurationService;
import com.atlassian.bitbucket.ssh.event.SshConfigurationChangedEvent;
import com.atlassian.bitbucket.util.ValidationUtils;
import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.CachedReferenceAdapter;
import com.atlassian.cache.CachedReferenceEvent;
import com.atlassian.cache.Supplier;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import java.util.OptionalInt;
import javax.annotation.Nonnull;
import javax.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class DefaultSshConfigurationService
implements SshConfigurationService,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(SshConfigurationService.class);
    private static final OptionalInt overriddenPort = DefaultSshConfigurationService.getOverriddenPort();
    private static final String SSH_CONFIGURATION_CACHE_KEY = SshConfiguration.class.getName();
    private static final String SYS_PROP_PORT_OVERRIDE = "plugin.ssh.port";
    private final EventPublisher eventPublisher;
    private final PermissionValidationService permissionValidationService;
    private final CachedReference<SshConfiguration> sshConfigurationReference;
    private final SshConfigurationDao sshConfigurationDao;
    private final TransactionTemplate transactionTemplate;
    private final TransactionSynchronisationManager transactionSynchronisationManager;
    private final Validator validator;
    private final CachedReferenceAdapter<SshConfiguration> sshConfigurationListener;

    public DefaultSshConfigurationService(EventPublisher eventPublisher, PermissionValidationService permissionValidationService, SshConfigurationDao sshConfigurationDao, TransactionTemplate transactionTemplate, TransactionSynchronisationManager transactionSynchronisationManager, Validator validator, CacheFactory cacheFactory) {
        this.eventPublisher = eventPublisher;
        this.permissionValidationService = permissionValidationService;
        this.sshConfigurationDao = sshConfigurationDao;
        this.transactionTemplate = transactionTemplate;
        this.transactionSynchronisationManager = transactionSynchronisationManager;
        this.validator = validator;
        this.sshConfigurationReference = cacheFactory.getCachedReference(SSH_CONFIGURATION_CACHE_KEY, (Supplier)new Supplier<SshConfiguration>(){

            public SshConfiguration get() {
                return DefaultSshConfigurationService.this.sshConfigurationDao.get();
            }
        }, new CacheSettingsBuilder().replicateViaInvalidation().build());
        this.sshConfigurationReference.reset();
        this.sshConfigurationListener = new CachedReferenceAdapter<SshConfiguration>(){

            public void onEvict(@Nonnull CachedReferenceEvent<SshConfiguration> event) {
                DefaultSshConfigurationService.this.notifyConfigurationRefresh();
            }

            public void onReset(@Nonnull CachedReferenceEvent<SshConfiguration> event) {
                DefaultSshConfigurationService.this.notifyConfigurationRefresh();
            }
        };
        this.sshConfigurationReference.addListener(this.sshConfigurationListener, false);
    }

    @Override
    @Nonnull
    public SshConfiguration getConfiguration() {
        try (ClassLoaderSetter setter = ClassLoaderSetter.with(SshConfiguration.class);){
            SshConfiguration result = (SshConfiguration)this.sshConfigurationReference.get();
            SshConfiguration sshConfiguration = overriddenPort.isPresent() ? new SimpleSshConfiguration(result.isEnabled(), result.isAccessKeysEnabled(), overriddenPort.getAsInt(), result.getBaseUrl()) : result;
            return sshConfiguration;
        }
    }

    @Override
    public void setConfiguration(final @Nonnull SshConfiguration newConfiguration) {
        this.permissionValidationService.validateForGlobal(Permission.SYS_ADMIN);
        ValidationUtils.validate((Validator)this.validator, (Object)newConfiguration, (Class[])new Class[0]);
        final SshConfiguration oldConfiguration = this.getConfiguration();
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Void>(){

            public Void doInTransaction() {
                DefaultSshConfigurationService.this.sshConfigurationDao.set(newConfiguration);
                DefaultSshConfigurationService.this.transactionSynchronisationManager.runOnSuccessfulCommit(new Runnable(){

                    @Override
                    public void run() {
                        try (ClassLoaderSetter setter = ClassLoaderSetter.with(SshConfiguration.class);){
                            DefaultSshConfigurationService.this.sshConfigurationReference.reset();
                        }
                        DefaultSshConfigurationService.this.notifyConfigurationChanged(oldConfiguration, newConfiguration);
                    }
                });
                return null;
            }
        });
    }

    public void destroy() throws Exception {
        this.sshConfigurationReference.removeListener(this.sshConfigurationListener);
    }

    private static OptionalInt getOverriddenPort() {
        String overridePort = System.getProperty(SYS_PROP_PORT_OVERRIDE);
        if (overridePort != null) {
            try {
                return OptionalInt.of(Integer.parseInt(overridePort));
            }
            catch (NumberFormatException e) {
                log.warn("Override {} value [{}] is not valid, ignoring", new Object[]{SYS_PROP_PORT_OVERRIDE, overridePort, e});
            }
        }
        return OptionalInt.empty();
    }

    private void notifyConfigurationChanged(SshConfiguration oldConfiguration, SshConfiguration newConfiguration) {
        this.eventPublisher.publish((Object)new SshConfigurationChangedEvent(this, oldConfiguration, newConfiguration));
    }

    private void notifyConfigurationRefresh() {
        this.eventPublisher.publish((Object)new SshConfigurationRefreshEvent(this));
    }

    private static class ClassLoaderSetter
    implements AutoCloseable {
        private final ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        private final ClassLoader overrideClassLoader;

        public static ClassLoaderSetter with(Class<?> clazz) {
            return new ClassLoaderSetter(clazz.getClassLoader());
        }

        public ClassLoaderSetter(ClassLoader overrideClassLoader) {
            this.overrideClassLoader = overrideClassLoader;
            Thread.currentThread().setContextClassLoader(overrideClassLoader);
        }

        @Override
        public void close() {
            Thread.currentThread().setContextClassLoader(this.originalClassLoader);
        }
    }
}

