/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.server;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.ssh.auth.PluginSshAuthenticationHandler;
import com.atlassian.bitbucket.internal.ssh.command.SshCommandProvider;
import com.atlassian.bitbucket.internal.ssh.server.SshCommandAdapter;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.event.api.EventPublisher;
import java.util.concurrent.ExecutorService;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.CommandFactory;

public class SshCommandAdapterCommandFactory
implements CommandFactory {
    private final PluginSshAuthenticationHandler authenticationHandler;
    private final EventPublisher eventPublisher;
    private final ExecutorService executorService;
    private final I18nService i18nService;
    private final RequestManager requestManager;
    private final SecurityService securityService;
    private final SshCommandProvider sshCommandProvider;

    public SshCommandAdapterCommandFactory(PluginSshAuthenticationHandler authenticationHandler, EventPublisher eventPublisher, ExecutorService executorService, I18nService i18nService, RequestManager requestManager, SecurityService securityService, SshCommandProvider sshCommandProvider) {
        this.authenticationHandler = authenticationHandler;
        this.eventPublisher = eventPublisher;
        this.executorService = executorService;
        this.i18nService = i18nService;
        this.requestManager = requestManager;
        this.securityService = securityService;
        this.sshCommandProvider = sshCommandProvider;
    }

    @Override
    public Command createCommand(String remoteCommand) {
        return new SshCommandAdapter(this.authenticationHandler, remoteCommand, this.eventPublisher, this.executorService, this.i18nService, this.requestManager, this.securityService, this.sshCommandProvider);
    }
}

