/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.server;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.event.auth.AuthenticationSuccessEvent;
import com.atlassian.bitbucket.experimental.request.ExperimentalRequestContext;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.ssh.auth.PluginSshAuthenticationHandler;
import com.atlassian.bitbucket.internal.ssh.command.SshCommandProvider;
import com.atlassian.bitbucket.internal.ssh.server.DefaultSshAuthenticationSuccessContext;
import com.atlassian.bitbucket.internal.ssh.server.SessionAttributes;
import com.atlassian.bitbucket.internal.ssh.server.SshAuthentication;
import com.atlassian.bitbucket.internal.ssh.server.SshKeyDetails;
import com.atlassian.bitbucket.repository.NoSuchRepositoryException;
import com.atlassian.bitbucket.request.RequestCallback;
import com.atlassian.bitbucket.request.RequestContext;
import com.atlassian.bitbucket.request.RequestInfoProvider;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.ssh.command.SshCommand;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.Operation;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.johnson.event.Event;
import com.google.common.base.Preconditions;
import com.google.common.io.CountingInputStream;
import com.google.common.io.CountingOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.zip.CRC32;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.mina.util.NamePreservingRunnable;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.SessionAware;
import org.apache.sshd.server.session.ServerSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshCommandAdapter
implements Command,
SessionAware,
RequestInfoProvider {
    private static final Logger log = LoggerFactory.getLogger(SshCommandAdapter.class);
    private final String commandString;
    private final EventPublisher eventPublisher;
    private final ExecutorService executorService;
    private final I18nService i18nService;
    private final RequestManager requestManager;
    private final SecurityService securityService;
    private final SshCommandProvider sshCommandProvider;
    private final PluginSshAuthenticationHandler authenticationHandler;
    private ExitCallback exitCallback;
    private CountingInputStream inputStream;
    private CountingOutputStream outputStream;
    private volatile boolean canceled;
    private OutputStream errorStream;
    private String remoteAddress;
    private volatile SshCommand command;
    private String sessionId;
    private ServerSession session;

    public SshCommandAdapter(PluginSshAuthenticationHandler authenticationHandler, String commandString, EventPublisher eventPublisher, ExecutorService executorService, I18nService i18nService, RequestManager requestManager, SecurityService securityService, SshCommandProvider sshCommandProvider) {
        this.authenticationHandler = (PluginSshAuthenticationHandler)Preconditions.checkNotNull((Object)authenticationHandler, (Object)"authenticationHandler");
        this.commandString = (String)Preconditions.checkNotNull((Object)commandString, (Object)"commandString");
        this.eventPublisher = (EventPublisher)Preconditions.checkNotNull((Object)eventPublisher, (Object)"eventPublisher");
        this.executorService = (ExecutorService)Preconditions.checkNotNull((Object)executorService, (Object)"executorService");
        this.i18nService = (I18nService)Preconditions.checkNotNull((Object)i18nService, (Object)"i18nService");
        this.requestManager = (RequestManager)Preconditions.checkNotNull((Object)requestManager, (Object)"requestManager");
        this.securityService = (SecurityService)Preconditions.checkNotNull((Object)securityService, (Object)"securityService");
        this.sshCommandProvider = (SshCommandProvider)Preconditions.checkNotNull((Object)sshCommandProvider, (Object)"sshCommandProvider");
    }

    @Override
    public void destroy() {
        SshCommand command = this.command;
        if (command != null) {
            this.canceled = true;
            command.cancel();
        }
    }

    @Nonnull
    public String getAction() {
        return "SSH - " + this.commandString;
    }

    @Nullable
    public String getDetails() {
        return null;
    }

    @Nonnull
    public String getProtocol() {
        return "ssh";
    }

    @Nonnull
    public Object getRawRequest() {
        return this;
    }

    @Nonnull
    public Object getRawResponse() {
        return this;
    }

    public String getRemoteAddress() {
        InetAddress inetAddress;
        InetSocketAddress socketAddress;
        if (this.remoteAddress == null && this.session.getIoSession() != null && (socketAddress = (InetSocketAddress)this.session.getIoSession().getRemoteAddress()) != null && (inetAddress = socketAddress.getAddress()) != null) {
            this.remoteAddress = inetAddress.getHostAddress();
        }
        return this.remoteAddress;
    }

    public String getSessionId() {
        if (this.sessionId == null) {
            CRC32 crc = new CRC32();
            crc.update(DigestUtils.sha1((byte[])this.session.getSessionId()));
            this.sessionId = Long.toString(crc.getValue(), 36);
        }
        return this.sessionId;
    }

    public boolean hasSessionId() {
        return true;
    }

    public boolean isSecure() {
        return true;
    }

    @Override
    public void start(Environment env) throws IOException {
        List<Event> johnsonEvents = this.session.getAttribute(SessionAttributes.ATTRIBUTE_JOHNSON_EVENTS);
        if (johnsonEvents != null) {
            this.handleJohnsoned(johnsonEvents);
            return;
        }
        SshAuthentication authentication = this.session.getAttribute(SessionAttributes.ATTRIBUTE_AUTH);
        if (authentication == null) {
            this.handleNoAuthentication();
            return;
        }
        this.executorService.execute(new NamePreservingRunnable(new SshCommandRunnable(authentication), "ssh-scm-request-handler"));
    }

    @Override
    public void setErrorStream(OutputStream err) {
        this.errorStream = err;
    }

    @Override
    public void setExitCallback(ExitCallback callback) {
        this.exitCallback = callback;
    }

    @Override
    public void setInputStream(InputStream in) {
        this.inputStream = new CountingInputStream(in);
    }

    @Override
    public void setOutputStream(OutputStream out) {
        this.outputStream = new CountingOutputStream(out);
    }

    @Override
    public void setSession(ServerSession session) {
        this.session = session;
    }

    private void handleJohnsoned(List<Event> events) throws IOException {
        this.errorStream.write((Product.NAME + " is currently unavailable:\n").getBytes(Charsets.UTF_8));
        for (Event event : events) {
            this.errorStream.write(("- " + event.getDesc() + '\n').getBytes(Charsets.UTF_8));
        }
        this.errorStream.flush();
        this.exitCallback.onExit(1);
    }

    private void handleNoAuthentication() {
        log.error("No user or SSH key access entries set in SSH ServerSession! Terminating SSH command.");
        this.exitCallback.onExit(1);
    }

    private void handleNoCommand() throws IOException {
        log.warn("{}: Command is not supported; no handler is available", (Object)this.commandString);
        this.writeErrorAndExit(this.i18nService.getMessage("bitbucket.plugin.ssh.no.request.handler", new Object[]{Product.NAME, this.commandString}));
    }

    private void writeErrorAndExit(String message) throws IOException {
        this.errorStream.write(message.getBytes());
        this.errorStream.write(10);
        this.errorStream.flush();
        this.exitCallback.onExit(1);
    }

    private class SshCommandRunnable
    implements Runnable {
        private final SshAuthentication authentication;
        private final OperationRequestAdapter thisAsAnImpersonatingRequest;

        public SshCommandRunnable(SshAuthentication authentication) {
            this.authentication = (SshAuthentication)Preconditions.checkNotNull((Object)authentication, (Object)"authentication");
            this.thisAsAnImpersonatingRequest = new OperationRequestAdapter();
        }

        @Override
        public void run() {
            try {
                SshCommandAdapter.this.securityService.impersonating(this.authentication.getUser(), "Authenticated using SSH key").call((Operation)this.thisAsAnImpersonatingRequest);
            }
            catch (IOException e) {
                if (SshCommandAdapter.this.canceled) {
                    log.debug("Exception encountered handling canceled SSH command '" + SshCommandAdapter.this.commandString + "'", (Throwable)e);
                }
                log.warn("Exception encountered handling SSH command '{}'", (Object)SshCommandAdapter.this.commandString, (Object)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void performAsRequest(@Nonnull ExperimentalRequestContext requestContext) throws IOException {
            ApplicationUser user = this.authentication.getUser();
            SshKeyDetails keyDetails = this.authentication.getKeyDetails();
            requestContext.setAuthenticatedUser(user);
            requestContext.addLabel("ssh:user:id:" + user.getId());
            if (!StringUtils.isEmpty((CharSequence)keyDetails.getId())) {
                requestContext.addLabel("ssh:id:" + keyDetails.getId());
            }
            if (!StringUtils.isEmpty((CharSequence)keyDetails.getLabel())) {
                requestContext.addLabel("ssh:label:" + keyDetails.getLabel());
            }
            this.handleAuthSuccess();
            int exitCode = 1;
            try {
                SshCommandAdapter.this.command = SshCommandAdapter.this.sshCommandProvider.getSshCommand(SshCommandAdapter.this.commandString, (InputStream)new CloseShieldInputStream((InputStream)SshCommandAdapter.this.inputStream), (OutputStream)new CloseShieldOutputStream((OutputStream)SshCommandAdapter.this.outputStream), (OutputStream)new CloseShieldOutputStream(SshCommandAdapter.this.errorStream)).orElse(null);
                if (SshCommandAdapter.this.command == null) {
                    try {
                        SshCommandAdapter.this.handleNoCommand();
                    }
                    catch (IOException e) {
                        log.warn("Exception encountered while handling unrecognised SSH command '{}'", (Object)SshCommandAdapter.this.commandString, (Object)e);
                    }
                    return;
                }
                exitCode = SshCommandAdapter.this.command.run();
            }
            catch (AuthorisationException | NoSuchRepositoryException e) {
                String message = SshCommandAdapter.this.i18nService.getMessage("bitbucket.scm.no.such.repository", new Object[0]) + "\n" + SshCommandAdapter.this.i18nService.getMessage("bitbucket.scm.no.such.repository.detail", new Object[0]);
                SshCommandAdapter.this.writeErrorAndExit(message);
            }
            catch (Exception e) {
                SshCommandAdapter.this.writeErrorAndExit(SshCommandAdapter.this.i18nService.getMessage("bitbucket.ssh.command.failed", new Object[0]));
                log.warn("Error encountered while handling SSH command '{}': {}", (Object)SshCommandAdapter.this.commandString, (Object)e.getMessage());
                log.debug("Error details:", (Throwable)e);
            }
            finally {
                SshCommandAdapter.this.exitCallback.onExit(exitCode);
                requestContext.setResponseCode(exitCode);
                requestContext.setBytesRead(SshCommandAdapter.this.inputStream.getCount());
                requestContext.setBytesWritten(SshCommandAdapter.this.outputStream.getCount());
            }
        }

        private void handleAuthSuccess() {
            ApplicationUser user = this.authentication.getUser();
            SshKeyDetails keyDetails = this.authentication.getKeyDetails();
            String keyUser = user.getName();
            String tokenDetails = "sshKey {" + (!StringUtils.isEmpty((CharSequence)keyDetails.getId()) ? "\"id\":\"" + keyDetails.getId() + "\", " : "") + (!StringUtils.isEmpty((CharSequence)keyDetails.getLabel()) ? "\"label\":\"" + keyDetails.getLabel() + "\", " : "") + "\"user.id\":" + user.getId() + "\", " + "\"name\":\"" + user.getDisplayName() + "\"}";
            SshCommandAdapter.this.eventPublisher.publish((Object)new AuthenticationSuccessEvent((Object)this, keyUser, "ssh", tokenDetails));
            SshCommandAdapter.this.authenticationHandler.onAuthenticationSuccess(new DefaultSshAuthenticationSuccessContext(this.authentication, SshCommandAdapter.this.commandString));
        }

        private class OperationRequestAdapter
        implements Operation<Void, IOException>,
        RequestCallback<Void, IOException> {
            private OperationRequestAdapter() {
            }

            public Void perform() throws IOException {
                return (Void)SshCommandAdapter.this.requestManager.doAsRequest((RequestCallback)this, (RequestInfoProvider)SshCommandAdapter.this);
            }

            @Nullable
            public Void withRequest(@Nonnull RequestContext requestContext) throws IOException {
                SshCommandRunnable.this.performAsRequest((ExperimentalRequestContext)requestContext);
                return null;
            }
        }
    }
}

