/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.server;

import java.io.IOException;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.server.channel.ChannelSession;

public class SelfClosingChannelSession
extends ChannelSession {
    private static final long DEFAULT_CLOSE_TIMEOUT = 30000L;
    private static final String CLOSE_TIMEOUT = "channel-close-timeout";

    @Override
    public CloseFuture close(boolean immediately) {
        final CloseFuture closeFuture = super.close(immediately);
        if (!closeFuture.isDone()) {
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    try {
                        SelfClosingChannelSession.this.handleClose();
                    }
                    catch (IOException e) {
                        SelfClosingChannelSession.this.log.warn("Failed to force close channel {}. Marking it as closed anyway", (Object)SelfClosingChannelSession.this.getId(), (Object)e);
                        closeFuture.setClosed();
                    }
                }
            };
            this.getSession().getFactoryManager().getScheduledExecutorService().schedule(task, this.getCloseTimeoutInMs(), TimeUnit.MILLISECONDS);
            closeFuture.addListener(new CancelTimerTask(task));
        }
        return closeFuture;
    }

    private long getCloseTimeoutInMs() {
        long timeout = 30000L;
        String timeoutAsString = this.getSession().getFactoryManager().getProperties().get(CLOSE_TIMEOUT);
        if (timeoutAsString != null) {
            try {
                timeout = Long.parseLong(timeoutAsString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return timeout;
    }

    private static class CancelTimerTask
    implements SshFutureListener<CloseFuture> {
        private final TimerTask task;

        private CancelTimerTask(TimerTask task) {
            this.task = task;
        }

        @Override
        public void operationComplete(CloseFuture future) {
            this.task.cancel();
        }
    }
}

