/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.server;

import com.atlassian.bitbucket.auth.AuthenticationException;
import com.atlassian.bitbucket.event.auth.AuthenticationFailureEvent;
import com.atlassian.bitbucket.internal.ssh.auth.PluginSshAuthenticationHandler;
import com.atlassian.bitbucket.internal.ssh.server.DefaultSshAuthenticationContext;
import com.atlassian.bitbucket.internal.ssh.server.DefaultSshAuthenticationFailureContext;
import com.atlassian.bitbucket.internal.ssh.server.SessionAttributes;
import com.atlassian.bitbucket.internal.ssh.server.SshAuthentication;
import com.atlassian.bitbucket.internal.ssh.server.SshCredentials;
import com.atlassian.bitbucket.internal.ssh.server.SshKeyDetails;
import com.atlassian.bitbucket.scm.AuthenticationState;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.ssh.util.KeyUtils;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.event.api.EventPublisher;
import com.google.common.base.Throwables;
import java.net.SocketAddress;
import java.security.PublicKey;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import org.apache.mina.util.NamePreservingRunnable;
import org.apache.sshd.server.PublickeyAuthenticator;
import org.apache.sshd.server.session.ServerSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPublicKeyAuthenticator
implements PublickeyAuthenticator {
    public static final String AUTHENTICATION_METHOD = "ssh";
    private static final Logger log = LoggerFactory.getLogger(DefaultPublicKeyAuthenticator.class);
    private final EventPublisher eventPublisher;
    private final PluginSshAuthenticationHandler authenticationHandler;
    private final ExecutorService executorService;
    private final ApplicationPropertiesService propertiesService;

    public DefaultPublicKeyAuthenticator(EventPublisher eventPublisher, PluginSshAuthenticationHandler authenticationHandler, ExecutorService executorService, ApplicationPropertiesService propertiesService) {
        this.eventPublisher = eventPublisher;
        this.authenticationHandler = authenticationHandler;
        this.executorService = executorService;
        this.propertiesService = propertiesService;
    }

    @Override
    public boolean authenticate(String username, PublicKey key, ServerSession session) {
        SshAuthentication authResult;
        SocketAddress remoteAddress = session.getIoSession().getRemoteAddress();
        SshCredentials credentials = new SshCredentials(username, key);
        Future<SshAuthentication> futureAuthResult = this.executorService.submit(() -> {
            Thread thread = Thread.currentThread();
            String oldName = thread.getName();
            thread.setName("ssh-auth");
            try {
                ApplicationUser user = this.authenticationHandler.authenticate(new DefaultSshAuthenticationContext(credentials));
                if (user == null) {
                    SshAuthentication sshAuthentication = null;
                    return sshAuthentication;
                }
                SshAuthentication sshAuthentication = new SshAuthentication(user, credentials, SshKeyDetails.getFromMDC());
                return sshAuthentication;
            }
            finally {
                thread.setName(oldName);
            }
        });
        try {
            authResult = futureAuthResult.get(this.propertiesService.getPluginProperty("plugin.ssh.auth.timeout", 30), TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.info("Interrupted while authenticating SSH user ({}:{}) at {}", new Object[]{username, KeyUtils.calculateFingerprint(key), remoteAddress});
            futureAuthResult.cancel(true);
            return false;
        }
        catch (TimeoutException e) {
            log.warn("Timed out while authenticating SSH user ({}:{}) at {}", new Object[]{username, KeyUtils.calculateFingerprint(key), remoteAddress, e});
            futureAuthResult.cancel(true);
            return false;
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof AuthenticationException) {
                log.debug("SSH user ({}:{}) at {} could not be authenticated", new Object[]{username, KeyUtils.calculateFingerprint(key), remoteAddress, log.isTraceEnabled() ? cause : null});
                this.handleAuthFailure(credentials, (AuthenticationException)cause);
                return false;
            }
            log.error("Error authenticating SSH user ({}:{}) at {}", new Object[]{username, KeyUtils.calculateFingerprint(key), remoteAddress, cause});
            throw Throwables.propagate((Throwable)cause);
        }
        session.setAttribute(SessionAttributes.ATTRIBUTE_AUTH, authResult);
        return true;
    }

    private void handleAuthFailure(@Nonnull SshCredentials credentials, @Nonnull AuthenticationException exception) {
        this.eventPublisher.publish((Object)new AuthenticationFailureEvent((Object)this, credentials.getUsername(), AUTHENTICATION_METHOD, exception));
        if (this.authenticationHandler.hasFailureHandlers()) {
            this.executorService.execute(new NamePreservingRunnable(() -> this.authenticationHandler.onAuthenticationFailure(new DefaultSshAuthenticationFailureContext(credentials, AuthenticationState.NOT_AUTHENTICATED, exception)), "ssh-scm-failure-handler"));
        }
    }
}

