/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.server;

import com.atlassian.bitbucket.internal.ssh.server.NamedFactoryFilter;
import com.atlassian.bitbucket.internal.ssh.server.NamedFactoryType;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.sshd.common.NamedFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultNamedFactoryFilter
implements NamedFactoryFilter {
    public static final Function<NamedFactory<?>, String> TO_NAME = new Function<NamedFactory<?>, String>(){

        public String apply(NamedFactory<?> factory) {
            return factory.getName();
        }
    };
    private static final Logger log = LoggerFactory.getLogger(DefaultNamedFactoryFilter.class);
    private final ApplicationPropertiesService propertiesService;

    @Autowired
    public DefaultNamedFactoryFilter(ApplicationPropertiesService propertiesService) {
        this.propertiesService = propertiesService;
    }

    @Override
    public <T> List<NamedFactory<T>> filter(@Nonnull List<NamedFactory<T>> defaultFactories, @Nonnull NamedFactoryType namedFactoryType) {
        Preconditions.checkNotNull(defaultFactories, (Object)"defaultFactories");
        Preconditions.checkNotNull((Object)((Object)namedFactoryType), (Object)"namedFactoryType");
        String factoriesToDisable = this.propertiesService.getPluginProperty(namedFactoryType.getDisabledFactoriesProperty(), "");
        ArrayList factories = Lists.newArrayList();
        Iterable factoriesToDisableIter = Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)factoriesToDisable);
        for (NamedFactory<T> factory : defaultFactories) {
            if (Iterables.contains((Iterable)factoriesToDisableIter, (Object)factory.getName())) continue;
            factories.add(factory);
        }
        log.debug("Available SSH {}: {}", (Object)namedFactoryType.name(), (Object)Iterables.transform((Iterable)factories, TO_NAME));
        return factories;
    }
}

