/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.scm;

import com.atlassian.bitbucket.internal.ssh.scm.ScmRequestSshCommand;
import com.atlassian.bitbucket.internal.ssh.server.DefaultingExitCodeCallback;
import com.atlassian.bitbucket.scm.ScmRequestCheckService;
import com.atlassian.bitbucket.scm.ssh.ExitCodeCallback;
import com.atlassian.bitbucket.scm.ssh.SshScmRequest;
import com.atlassian.bitbucket.scm.ssh.SshScmRequestHandler;
import com.atlassian.bitbucket.scm.ssh.SshScmRequestHandlerModuleDescriptor;
import com.atlassian.bitbucket.ssh.command.SshCommand;
import com.atlassian.bitbucket.ssh.command.SshCommandFactory;
import com.atlassian.bitbucket.util.ModuleDescriptorUtils;
import com.atlassian.plugin.PluginAccessor;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class ScmRequestSshCommandFactory
implements SshCommandFactory {
    private final PluginAccessor pluginAccessor;
    private final ScmRequestCheckService scmRequestCheckService;

    public ScmRequestSshCommandFactory(PluginAccessor pluginAccessor, ScmRequestCheckService scmRequestCheckService) {
        this.pluginAccessor = pluginAccessor;
        this.scmRequestCheckService = scmRequestCheckService;
    }

    @Nonnull
    public Optional<SshCommand> create(@Nonnull String command, @Nonnull InputStream stdin, @Nonnull OutputStream stdout, @Nonnull OutputStream stderr) {
        Optional<SshScmRequestHandler> optionalHandler = this.getHandler(command);
        if (!optionalHandler.isPresent()) {
            return Optional.empty();
        }
        SshScmRequestHandler handler = optionalHandler.get();
        DefaultingExitCodeCallback exitCodeCallback = new DefaultingExitCodeCallback();
        Optional sshScmRequest = handler.create(command, stdin, stdout, stderr, (ExitCodeCallback)exitCodeCallback);
        return sshScmRequest.map(request -> new ScmRequestSshCommand((SshScmRequest)request, exitCodeCallback, this.scmRequestCheckService));
    }

    public boolean supports(@Nonnull String command) {
        return this.getHandler(command).isPresent();
    }

    private Optional<SshScmRequestHandler> getHandler(String command) {
        return this.getHandlers().filter(handler -> handler.supports(command)).findFirst();
    }

    private Stream<SshScmRequestHandler> getHandlers() {
        return ModuleDescriptorUtils.toSortedModules((Collection)this.pluginAccessor.getEnabledModuleDescriptorsByClass(SshScmRequestHandlerModuleDescriptor.class));
    }
}

