/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.rest;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.ssh.rest.RestSshKey;
import com.atlassian.bitbucket.rest.util.ResponseFactory;
import com.atlassian.bitbucket.rest.util.RestPage;
import com.atlassian.bitbucket.ssh.SshKey;
import com.atlassian.bitbucket.ssh.SshKeyService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.NoSuchUserException;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.sun.jersey.spi.resource.Singleton;
import java.net.URI;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Path(value="keys")
public class SshKeysResource {
    private static final Logger log = LoggerFactory.getLogger(SshKeysResource.class);
    private final AuthenticationContext authContext;
    private final UserService userService;
    private final SshKeyService sshKeyService;
    private final I18nService i18nService;

    public SshKeysResource(AuthenticationContext authContext, UserService userService, SshKeyService sshKeyService, I18nService i18nService) {
        this.authContext = authContext;
        this.userService = userService;
        this.sshKeyService = sshKeyService;
        this.i18nService = i18nService;
    }

    @GET
    public Response getSshKeys(@QueryParam(value="user") String userName, @Context PageRequest pageRequest) {
        log.debug("Entered getSshKeys method");
        ApplicationUser user = this.getUser(userName);
        Page<SshKey> keys = this.sshKeyService.findAllForUser(user, pageRequest);
        log.debug("Retrieved keys: {}", keys);
        Response response = ResponseFactory.ok((Object)new RestPage(keys, RestSshKey.REST_TRANSFORM)).build();
        log.debug("Built response");
        return response;
    }

    @POST
    public Response addSshKey(@QueryParam(value="user") String userName, RestSshKey key, @Context UriInfo uriInfo) {
        SshKey sshKey = this.sshKeyService.addForUser(this.getUser(userName), key.getText());
        URI uri = uriInfo.getRequestUriBuilder().replaceQuery(null).path(Integer.toString(sshKey.getId())).build(new Object[0]);
        return ResponseFactory.created((URI)uri).entity((Object)new RestSshKey(sshKey)).build();
    }

    @DELETE
    @Path(value="/{keyId}")
    public Response deleteSshKey(@PathParam(value="keyId") Integer keyId) {
        this.sshKeyService.remove(keyId);
        return ResponseFactory.noContent().build();
    }

    @DELETE
    public Response deleteSshKeys(@QueryParam(value="user") String userName) {
        this.sshKeyService.removeAllForUser(this.getUser(userName));
        return ResponseFactory.noContent().build();
    }

    @Nonnull
    private ApplicationUser getUser(@Nullable String username) {
        ApplicationUser user = this.authContext.getCurrentUser();
        if (username != null && (user = this.userService.getUserByName(username)) == null) {
            user = this.userService.getServiceUserByName(username);
        }
        if (user == null) {
            throw new NoSuchUserException(this.i18nService.createKeyedMessage("bitbucket.rest.ssh.user.notfound", new Object[0]), username);
        }
        return user;
    }
}

