/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.rest;

import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.rest.util.RestDocUtils;
import com.atlassian.bitbucket.rest.util.RestPage;
import com.atlassian.bitbucket.ssh.SshKey;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
public class RestSshKey
extends RestMapEntity {
    private static final String ID = "id";
    private static final String TEXT = "text";
    private static final String LABEL = "label";
    public static final Function<SshKey, RestSshKey> REST_TRANSFORM = RestSshKey::new;
    public static final RestSshKey EXAMPLE_REQUEST = new RestSshKey(null, "ssh-rsa AAAAB3... me@127.0.0.1", null);
    public static final RestSshKey EXAMPLE_RESPONSE = new RestSshKey(1, "ssh-rsa AAAAB3... me@127.0.0.1", "me@127.0.0.1");
    public static final RestPage<RestSshKey> EXAMPLE_PAGE = RestDocUtils.pageOf((Object[])new RestSshKey[]{EXAMPLE_RESPONSE});

    public RestSshKey() {
    }

    public RestSshKey(SshKey sshKey) {
        this(sshKey.getId(), sshKey.getText(), sshKey.getLabel());
    }

    public RestSshKey(Integer id, String text, String label) {
        this.putIfNotNull(ID, id);
        this.putIfNotNull(TEXT, text);
        this.putIfNotNull(LABEL, label);
    }

    private RestSshKey(Map<String, Object> map) {
        super(map);
    }

    public Integer getId() {
        return this.getIntProperty(ID);
    }

    public String getText() {
        return this.getStringProperty(TEXT);
    }

    public String getLabel() {
        return this.getStringProperty(LABEL);
    }

    @Nullable
    public static RestSshKey valueOf(@Nullable Object value) {
        if (value instanceof RestSshKey) {
            return (RestSshKey)((Object)value);
        }
        if (value instanceof Map) {
            return new RestSshKey((Map)value);
        }
        return null;
    }
}

