/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.fragments;

import com.atlassian.bitbucket.internal.ssh.dao.SshConfigurationDao;
import com.atlassian.bitbucket.internal.ssh.server.HostKeyPairProvider;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.ssh.SshAccessKey;
import com.atlassian.bitbucket.ssh.SshAccessKeyService;
import com.atlassian.bitbucket.ssh.SshConfiguration;
import com.atlassian.bitbucket.ssh.SshKey;
import com.atlassian.bitbucket.ssh.SshKeyService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.Person;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class SshKeysContextProvider
implements ContextProvider {
    private static final PageRequest DEFAULT_PAGE_REQUEST = PageUtils.newRequest((int)0, (int)50);
    private final SshConfigurationDao sshConfig;
    private final SshAccessKeyService keyAccessService;
    private final SshKeyService keyService;
    private final HostKeyPairProvider keyPairProvider;
    private final UserService userService;
    private final NavBuilder navBuilder;

    public SshKeysContextProvider(SshConfigurationDao sshConfig, SshAccessKeyService keyAccessService, SshKeyService keyService, HostKeyPairProvider keyPairProvider, UserService userService, NavBuilder navBuilder) {
        this.sshConfig = sshConfig;
        this.keyAccessService = keyAccessService;
        this.keyService = keyService;
        this.keyPairProvider = keyPairProvider;
        this.userService = userService;
        this.navBuilder = navBuilder;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        ApplicationUser user = SshKeysContextProvider.convertToApplicationUser((Person)context.get("user"), this.userService);
        String addKeyUrl = this.baseUrl().path(new String[]{"ssh", "admin", "users", user.getSlug(), "keys", "add"}).buildRelative();
        return this.createKeyTableContext(context, user, this.sshConfig.get().isEnabled(), addKeyUrl);
    }

    public Map<String, Object> createKeyTableContext(Map<String, Object> context, ApplicationUser user) {
        String addKeyUrl = this.baseUrl().path(new String[]{"ssh", "account", "keys", "add"}).buildRelative();
        return this.createKeyTableContext(context, user, true, addKeyUrl);
    }

    public Map<String, Object> createKeyTableContext(Map<String, Object> context, Repository repository) {
        Page<SshAccessKey> keyAccesses = this.keyAccessService.findByRepository(repository, DEFAULT_PAGE_REQUEST);
        String addKeyUrl = this.baseUrl().path(new String[]{"ssh", "projects", repository.getProject().getKey(), "repos", repository.getSlug(), "keys", "add"}).buildRelative();
        return this.createResourceKeysContext(context, "repository", repository, keyAccesses, addKeyUrl);
    }

    public Map<String, Object> createKeyTableContext(Map<String, Object> context, Project project) {
        Page<SshAccessKey> keyAccesses = this.keyAccessService.findByProject(project, DEFAULT_PAGE_REQUEST);
        String addKeyUrl = this.baseUrl().path(new String[]{"ssh", "projects", project.getKey(), "keys", "add"}).buildRelative();
        return this.createResourceKeysContext(context, "project", project, keyAccesses, addKeyUrl);
    }

    private Map<String, Object> createResourceKeysContext(Map<String, Object> context, String resourceName, Object resource, Page<? extends SshAccessKey> keyAccesses, String addKeyUrl) {
        SshConfiguration config = this.sshConfig.get();
        boolean addEnabled = config.isEnabled() && config.isAccessKeysEnabled();
        return this.createKeysContext(keyAccesses, context, addEnabled, addKeyUrl, resourceName, resource);
    }

    private Map<String, Object> createKeyTableContext(Map<String, Object> context, ApplicationUser user, boolean addEnabled, String addKeyUrl) {
        Page<SshKey> keys = this.keyService.findAllForUser(user, null);
        return this.createKeysContext(keys, context, addEnabled, addKeyUrl, "user", user);
    }

    private static String makeSshFormat(String fingerprint) {
        return Joiner.on((char)':').join(Splitter.fixedLength((int)2).split((CharSequence)fingerprint));
    }

    private NavBuilder.PathBuilder<NavBuilder.PluginServlets> baseUrl() {
        return this.navBuilder.pluginServlets();
    }

    private <K> Map<String, Object> createKeysContext(Page<K> keys, Map<String, Object> additionalContext, boolean addEnabled, String addKeyUrl, String resourceContextKey, Object resource) {
        ImmutableMap.Builder mb = ImmutableMap.builder().putAll(additionalContext).put((Object)"addKeyUrl", (Object)addKeyUrl).put((Object)"keyPage", keys).put((Object)"addEnabled", (Object)addEnabled);
        if (!additionalContext.containsKey(resourceContextKey)) {
            mb.put((Object)resourceContextKey, resource);
        } else if (additionalContext.get(resourceContextKey) != resource) {
            throw new IllegalArgumentException("Context already contains key '" + resourceContextKey + "' with a different value");
        }
        if (keys.getSize() > 0) {
            mb.put((Object)"fingerprint", (Object)SshKeysContextProvider.makeSshFormat(this.keyPairProvider.getFingerprint()));
            mb.put((Object)"algorithm", (Object)this.keyPairProvider.getAlgorithm());
        }
        return mb.build();
    }

    private static ApplicationUser convertToApplicationUser(Person user, UserService userService) {
        return user instanceof ApplicationUser ? (ApplicationUser)user : userService.getUserByName(user.getName());
    }
}

