/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.fragments;

import com.atlassian.bitbucket.ssh.SimpleSshConfiguration;
import com.atlassian.bitbucket.ssh.SshConfiguration;
import com.atlassian.bitbucket.ssh.validation.SshBaseUrl;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.Range;

public class SshConfigurationForm {
    private final boolean accessKeysEnabled;
    private final boolean enabled;
    private final String port;
    private final String sshBaseUrl;

    public SshConfigurationForm(boolean enabled, boolean accessKeysEnabled, String port, String sshBaseUrl) {
        this.accessKeysEnabled = accessKeysEnabled;
        this.enabled = enabled;
        this.port = port;
        this.sshBaseUrl = sshBaseUrl;
    }

    public boolean isAccessKeysEnabled() {
        return this.accessKeysEnabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @NotBlank
    @Range(min=1024L, max=65535L)
    public String getPort() {
        return this.port;
    }

    @SshBaseUrl
    public String getBaseUrl() {
        return this.sshBaseUrl;
    }

    public SshConfiguration toSshConfiguration() {
        return new SimpleSshConfiguration(this.enabled, this.accessKeysEnabled, Integer.parseInt(this.port), this.sshBaseUrl);
    }
}

