/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.auth;

import com.atlassian.bitbucket.auth.SshAuthenticationContext;
import com.atlassian.bitbucket.auth.SshAuthenticationFailureContext;
import com.atlassian.bitbucket.auth.SshAuthenticationFailureHandler;
import com.atlassian.bitbucket.auth.SshAuthenticationFailureHandlerModuleDescriptor;
import com.atlassian.bitbucket.auth.SshAuthenticationHandler;
import com.atlassian.bitbucket.auth.SshAuthenticationHandlerModuleDescriptor;
import com.atlassian.bitbucket.auth.SshAuthenticationSuccessContext;
import com.atlassian.bitbucket.auth.SshAuthenticationSuccessHandler;
import com.atlassian.bitbucket.auth.SshAuthenticationSuccessHandlerModuleDescriptor;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.ssh.auth.SshAuthenticationHandlerNotFoundException;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.ModuleDescriptorUtils;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.plugin.PluginAccessor;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginSshAuthenticationHandler
implements SshAuthenticationHandler,
SshAuthenticationSuccessHandler,
SshAuthenticationFailureHandler {
    private static final Logger log = LoggerFactory.getLogger(PluginSshAuthenticationHandler.class);
    private final I18nService i18nService;
    private final PluginAccessor pluginAccessor;

    public PluginSshAuthenticationHandler(I18nService i18nService, PluginAccessor pluginAccessor) {
        this.i18nService = i18nService;
        this.pluginAccessor = pluginAccessor;
    }

    public ApplicationUser authenticate(@Nonnull SshAuthenticationContext context) {
        for (SshAuthenticationHandler handler : this.getHandlers()) {
            String handlerName = handler.getClass().getName();
            Timer ignored = TimerUtils.start((String)(handlerName + ".authentication"));
            Throwable throwable = null;
            try {
                log.debug("authenticate - trying handler {}", (Object)handlerName);
                ApplicationUser user = handler.authenticate(context);
                if (user == null) continue;
                log.debug("authenticate - handler {} authenticated user {}", (Object)handlerName, (Object)user.getName());
                ApplicationUser applicationUser = user;
                return applicationUser;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ignored == null) continue;
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ignored.close();
            }
        }
        log.debug("authenticate - none of the plugins handled authentication");
        throw new SshAuthenticationHandlerNotFoundException(this.i18nService.createKeyedMessage("bitbucket.service.ssh.key.auth.nohandler", new Object[]{context.getUsername()}));
    }

    public boolean hasFailureHandlers() {
        return this.getFailureHandlers().findFirst().isPresent();
    }

    public void onAuthenticationFailure(@Nonnull SshAuthenticationFailureContext context) {
        this.getFailureHandlers().forEach(handler -> {
            String handlerName = handler.getClass().getName();
            try (Timer ignored = TimerUtils.start((String)(handlerName + ".onAuthenticationFailure"));){
                log.debug("onAuthenticationFailure - trying handler {}", (Object)handlerName);
                handler.onAuthenticationFailure(context);
            }
            catch (Exception e) {
                log.error("{} {} failed", new Object[]{SshAuthenticationFailureHandler.class.getSimpleName(), handlerName, e});
            }
        });
    }

    public void onAuthenticationSuccess(@Nonnull SshAuthenticationSuccessContext context) {
        this.getSuccessHandlers().forEach(handler -> {
            String handlerName = handler.getClass().getName();
            try (Timer ignored = TimerUtils.start((String)(handlerName + ".onAuthenticationSuccess"));){
                log.debug("onAuthenticationSuccess - trying handler {}", (Object)handlerName);
                handler.onAuthenticationSuccess(context);
            }
            catch (Exception e) {
                log.error("{} {} failed", new Object[]{SshAuthenticationSuccessHandler.class.getSimpleName(), handlerName, e});
            }
        });
    }

    private Stream<SshAuthenticationFailureHandler> getFailureHandlers() {
        return ModuleDescriptorUtils.toSortedModules((Collection)this.pluginAccessor.getEnabledModuleDescriptorsByClass(SshAuthenticationFailureHandlerModuleDescriptor.class));
    }

    private Iterable<SshAuthenticationHandler> getHandlers() {
        return ModuleDescriptorUtils.toSortedModules((Collection)this.pluginAccessor.getEnabledModuleDescriptorsByClass(SshAuthenticationHandlerModuleDescriptor.class)).collect(Collectors.toList());
    }

    private Stream<SshAuthenticationSuccessHandler> getSuccessHandlers() {
        return ModuleDescriptorUtils.toSortedModules((Collection)this.pluginAccessor.getEnabledModuleDescriptorsByClass(SshAuthenticationSuccessHandlerModuleDescriptor.class));
    }
}

