/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.ssh.event;

import com.atlassian.bitbucket.audit.AuditEntry;
import com.atlassian.bitbucket.audit.AuditEntryBuilder;
import com.atlassian.bitbucket.audit.AuditEntryConverter;
import com.atlassian.bitbucket.ssh.SshKey;
import com.atlassian.bitbucket.ssh.event.SshKeyEvent;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.AuditUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class SshKeyEventConverter
implements AuditEntryConverter<SshKeyEvent> {
    @Nonnull
    public AuditEntry convert(@Nonnull SshKeyEvent event, AuditEntryBuilder builder) {
        String target;
        ApplicationUser user;
        SshKey key = (SshKey)Preconditions.checkNotNull((Object)((SshKeyEvent)((Object)Preconditions.checkNotNull((Object)((Object)event), (Object)"event"))).getKey(), (Object)"event.key");
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>();
        details.put("id", key.getId());
        details.put("public-key", key.getText());
        if (key.getLabel() != null) {
            details.put("label", key.getLabel());
        }
        if ((user = key.getUser()) != null) {
            details.put("user", SshKeyEventConverter.createUserMap(user));
            target = user.getSlug();
        } else {
            target = "Global";
        }
        return builder.action(((Object)((Object)event)).getClass()).timestamp(new Date()).details(AuditUtils.toJson(details)).user(event.getUser()).target(target).build();
    }

    private static Map<String, Object> createUserMap(ApplicationUser user) {
        return ImmutableMap.builder().put((Object)"id", (Object)user.getId()).put((Object)"name", (Object)user.getName()).put((Object)"slug", (Object)user.getSlug()).build();
    }
}

