/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.user;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionAdminService;
import com.atlassian.bitbucket.permission.SetPermissionRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.user.RestApplicationUser;
import com.atlassian.bitbucket.rest.user.RestDetailedGroup;
import com.atlassian.bitbucket.rest.user.RestPermittedGroup;
import com.atlassian.bitbucket.rest.user.RestPermittedUser;
import com.atlassian.bitbucket.rest.util.ResponseFactory;
import com.atlassian.bitbucket.rest.util.RestPage;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.stash.internal.rest.user.AbstractPermissionResource;
import com.sun.jersey.spi.resource.Singleton;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="projects/{projectKey}/repos/{repositorySlug}/permissions")
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@AnonymousAllowed
public class RepositoryPermissionResource
extends AbstractPermissionResource {
    public RepositoryPermissionResource(PermissionAdminService permissionAdminService, UserService userService, I18nService i18nService) {
        super(i18nService, permissionAdminService, userService);
    }

    @GET
    @Path(value="groups")
    public Response getGroupsWithAnyPermission(@Context Repository repository, @QueryParam(value="filter") String filter, @Context PageRequest pageRequest) {
        Page page = this.permissionAdminService.findGroupsWithRepositoryPermission(repository, filter, pageRequest);
        return ResponseFactory.ok(new RestPage<RestPermittedGroup>(page, RestPermittedGroup.REST_TRANSFORM)).build();
    }

    @GET
    @Path(value="groups/none")
    public Response getGroupsWithoutAnyPermission(@Context Repository repository, @QueryParam(value="filter") String filter, @Context PageRequest pageRequest) {
        Page page = this.permissionAdminService.findGroupsWithoutRepositoryPermission(repository, filter, pageRequest);
        return ResponseFactory.ok(new RestPage<RestDetailedGroup>(page, RestDetailedGroup.NAME_TRANSFORM)).build();
    }

    @GET
    @Path(value="users")
    public Response getUsersWithAnyPermission(@Context Repository repository, @QueryParam(value="filter") String filter, @Context PageRequest pageRequest) {
        Page page = this.permissionAdminService.findUsersWithRepositoryPermission(repository, filter, pageRequest);
        return ResponseFactory.ok(new RestPage<RestPermittedUser>(page, RestPermittedUser.REST_TRANSFORM)).build();
    }

    @GET
    @Path(value="users/none")
    public Response getUsersWithoutPermission(@Context Repository repository, @QueryParam(value="filter") String filter, @Context PageRequest pageRequest) {
        Page page = this.permissionAdminService.findLicensedUsersWithoutRepositoryPermission(repository, filter, pageRequest);
        return ResponseFactory.ok(new RestPage<RestApplicationUser>(page, RestApplicationUser.REST_TRANSFORM)).build();
    }

    @PUT
    @Path(value="groups")
    public Response setPermissionForGroup(@Context Repository repository, @QueryParam(value="permission") String permissionName, @QueryParam(value="name") Set<String> groupNames) {
        Permission permission = this.validatePermission(permissionName, Repository.class);
        Set<String> groups = this.validateGroups(groupNames, false);
        this.permissionAdminService.setPermission(new SetPermissionRequest.Builder().repositoryPermission(permission, repository).groups(groups).build());
        return ResponseFactory.noContent().build();
    }

    @PUT
    @Path(value="users")
    public Response setPermissionForUser(@Context Repository repository, @QueryParam(value="name") Set<String> usernames, @QueryParam(value="permission") String permissionName) {
        Permission permission = this.validatePermission(permissionName, Repository.class);
        Set<ApplicationUser> users = this.validateUsers(usernames, false);
        this.permissionAdminService.setPermission(new SetPermissionRequest.Builder().repositoryPermission(permission, repository).users(users).build());
        return ResponseFactory.noContent().build();
    }

    @DELETE
    @Path(value="groups")
    public Response revokePermissionsForGroup(@Context Repository repository, @QueryParam(value="name") String groupName) {
        groupName = this.validateGroup(groupName, true);
        this.permissionAdminService.revokeAllRepositoryPermissions(repository, groupName);
        return ResponseFactory.noContent().build();
    }

    @DELETE
    @Path(value="users")
    public Response revokePermissionsForUser(@Context Repository repository, @QueryParam(value="name") String username) {
        ApplicationUser user = this.validateUser(username, true);
        this.permissionAdminService.revokeAllRepositoryPermissions(repository, user);
        return ResponseFactory.noContent().build();
    }
}

