/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.task;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.rest.BadRequestException;
import com.atlassian.bitbucket.rest.RestResource;
import com.atlassian.bitbucket.rest.task.RestTask;
import com.atlassian.bitbucket.rest.util.ResponseFactory;
import com.atlassian.bitbucket.task.Task;
import com.atlassian.bitbucket.task.TaskCreateRequest;
import com.atlassian.bitbucket.task.TaskService;
import com.atlassian.bitbucket.task.TaskUpdateRequest;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.sun.jersey.spi.resource.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang.StringUtils;

@AnonymousAllowed
@Consumes(value={"application/json"})
@Path(value="tasks")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class TaskResource
extends RestResource {
    private final TaskService taskService;

    public TaskResource(I18nService i18nService, TaskService taskService) {
        super(i18nService);
        this.taskService = taskService;
    }

    @POST
    public Response createTask(RestTask task, @Context UriInfo uriInfo) {
        this.validateCreatePayload(task);
        Task createdTask = this.taskService.create(this.toCreateRequest(task));
        return ResponseFactory.created(uriInfo.getRequestUriBuilder().path(String.valueOf(createdTask.getId())).build(new Object[0])).entity(RestTask.REST_TRANSFORM.apply((Object)createdTask)).build();
    }

    @DELETE
    @Path(value="{taskId}")
    public Response deleteTask(@PathParam(value="taskId") long taskId) {
        this.taskService.delete(taskId);
        return ResponseFactory.noContent().build();
    }

    @GET
    @Path(value="{taskId}")
    public Response getTask(@Context Task task) {
        return this.respondWith(task);
    }

    @PUT
    @Path(value="{taskId}")
    public Response updateTask(@Context Task task, RestTask update) {
        this.validateUpdatePayload(task, update);
        TaskUpdateRequest.Builder builder = new TaskUpdateRequest.Builder(task);
        if (update.getState() != null) {
            builder.state(update.getState());
        }
        if (update.getText() != null) {
            builder.text(update.getText());
        }
        Task updatedTask = this.taskService.update(builder.build());
        return this.respondWith(updatedTask);
    }

    private TaskCreateRequest toCreateRequest(RestTask task) {
        return new TaskCreateRequest.Builder().anchorId(task.getAnchorId()).anchorType(task.getAnchorType()).text(task.getText()).build();
    }

    private Response respondWith(Task task) {
        return ResponseFactory.ok().entity(RestTask.REST_TRANSFORM.apply((Object)task)).build();
    }

    private void validateCreatePayload(RestTask task) {
        if (task.getId() > 0L) {
            throw new BadRequestException(this.i18nService.getMessage("stash.rest.task.createidnotallowed", new Object[0]));
        }
        if (StringUtils.isBlank((String)task.getText())) {
            throw new BadRequestException(this.i18nService.getMessage("stash.rest.task.createrequirestext", new Object[0]));
        }
        if (task.getAnchorId() == 0L || task.getAnchorType() == null) {
            throw new BadRequestException(this.i18nService.getMessage("stash.rest.task.createrequiresanchor", new Object[0]));
        }
    }

    private void validateUpdatePayload(Task task, RestTask update) {
        if (update.getId() > 0L && update.getId() != task.getId()) {
            throw new BadRequestException(this.i18nService.getMessage("stash.rest.task.updateidmismatch", new Object[]{update.getId(), task.getId()}));
        }
        if (update.getText() != null && StringUtils.isBlank((String)update.getText())) {
            throw new BadRequestException(this.i18nService.getMessage("stash.rest.task.updaterequirestext", new Object[0]));
        }
    }
}

