/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.repository;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositorySearchRequest;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.repository.RepositoryVisibility;
import com.atlassian.bitbucket.rest.RestErrors;
import com.atlassian.bitbucket.rest.RestResource;
import com.atlassian.bitbucket.rest.repository.RestRepository;
import com.atlassian.bitbucket.rest.util.ResponseFactory;
import com.atlassian.bitbucket.rest.util.RestPage;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.stash.internal.rest.util.RestPermissionUtils;
import com.google.common.base.Preconditions;
import com.sun.jersey.spi.resource.Singleton;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;

@AnonymousAllowed
@Consumes(value={"application/json"})
@Path(value="repos")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class RepositorySearchResource
extends RestResource {
    private final RepositoryService repositoryService;

    public RepositorySearchResource(@Nonnull I18nService i18nService, @Nonnull RepositoryService repositoryService) {
        super((I18nService)Preconditions.checkNotNull((Object)i18nService, (Object)"i18nService"));
        this.repositoryService = (RepositoryService)Preconditions.checkNotNull((Object)repositoryService, (Object)"repositoryService");
    }

    @GET
    public Response getRepositories(@QueryParam(value="name") String name, @QueryParam(value="projectname") String projectname, @QueryParam(value="permission") String permission, @QueryParam(value="visibility") String visibility, @Context PageRequest pageRequest) {
        RepositorySearchRequest.Builder builder = new RepositorySearchRequest.Builder().name(name).permission(RestPermissionUtils.parsePermission(this.i18nService, permission, Repository.class)).projectName(projectname);
        if (StringUtils.isNotBlank((String)visibility)) {
            try {
                builder.visibility(RepositoryVisibility.valueOf((String)visibility.toUpperCase(Locale.US)));
            }
            catch (IllegalArgumentException e) {
                return ResponseFactory.status(Response.Status.BAD_REQUEST).entity((Object)new RestErrors(this.i18nService.getMessage("stash.rest.repository.search.nosuchvisibility", new Object[]{visibility}))).build();
            }
        }
        Page page = this.repositoryService.search(builder.build(), pageRequest);
        return ResponseFactory.ok(new RestPage<RestRepository>(page, RestRepository.REST_TRANSFORM)).build();
    }
}

