/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.pull;

import com.atlassian.bitbucket.commit.CommitCallback;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.commit.RestCommit;
import com.atlassian.bitbucket.rest.enrich.AvatarEnricher;
import com.atlassian.bitbucket.rest.util.JsonStreamingOutput;
import com.atlassian.bitbucket.rest.util.ResponseFactory;
import com.atlassian.bitbucket.rest.util.StatefulJsonWriter;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.stash.internal.rest.pull.AbstractPullRequestResource;
import com.atlassian.stash.internal.rest.pull.JsonCommitCallback;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.resource.Singleton;
import java.io.IOException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@AnonymousAllowed
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/commits")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class PullRequestCommitResource
extends AbstractPullRequestResource {
    private final AvatarEnricher avatarEnricher;

    public PullRequestCommitResource(I18nService i18nService, PullRequestService pullRequestService, AvatarEnricher avatarEnricher) {
        super(i18nService, pullRequestService);
        this.avatarEnricher = avatarEnricher;
    }

    @GET
    public Response getCommits(final @Context Repository repository, final @PathParam(value="pullRequestId") long pullRequestId, final @QueryParam(value="withCounts") boolean withCounts, final @Context PageRequest pageRequest, final @Context ContainerRequest request) {
        return ResponseFactory.ok(new JsonStreamingOutput(){

            @Override
            public void write(StatefulJsonWriter writer) throws IOException, WebApplicationException {
                JsonCommitCallback callback = new JsonCommitCallback(writer, RestCommit.createTransformer(request, PullRequestCommitResource.this.avatarEnricher), withCounts, pageRequest);
                PullRequestCommitResource.this.pullRequestService.streamCommits(repository.getId(), pullRequestId, (CommitCallback)callback);
            }
        }).build();
    }
}

