/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.inject;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.task.NoSuchTaskException;
import com.atlassian.bitbucket.task.Task;
import com.atlassian.bitbucket.task.TaskService;
import com.atlassian.stash.internal.rest.inject.AbstractResourceInjectable;
import com.atlassian.stash.internal.rest.util.HttpContextUtils;
import com.sun.jersey.api.core.HttpContext;
import javax.annotation.Nonnull;

public class TaskInjectable
extends AbstractResourceInjectable<Task> {
    private final I18nService i18nService;
    private final TaskService taskService;

    public TaskInjectable(I18nService i18nService, TaskService taskService) {
        this.i18nService = i18nService;
        this.taskService = taskService;
    }

    @Override
    @Nonnull
    public Task doGetValue(HttpContext httpContext) {
        String taskId = HttpContextUtils.requireSinglePathSegmentValue("taskId", httpContext, Task.class);
        return this.getTask(taskId);
    }

    private Task getTask(String taskId) {
        try {
            Task task = this.taskService.getById(Long.parseLong(taskId));
            if (task != null) {
                return task;
            }
        }
        catch (AuthorisationException | NumberFormatException throwable) {
            // empty catch block
        }
        throw new NoSuchTaskException(this.i18nService.createKeyedMessage("stash.rest.task.nosuchtask", new Object[]{taskId}));
    }
}

