/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.inject;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.project.NoSuchProjectException;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectService;
import com.atlassian.bitbucket.repository.NoSuchRepositoryException;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.stash.internal.rest.inject.AbstractResourceInjectable;
import com.atlassian.stash.internal.rest.util.HttpContextUtils;
import com.sun.jersey.api.core.HttpContext;
import javax.annotation.Nonnull;

public class RepositoryInjectable
extends AbstractResourceInjectable<Repository> {
    private final I18nService i18nService;
    private final ProjectService projectService;
    private final RepositoryService repositoryService;

    public RepositoryInjectable(I18nService i18nService, ProjectService projectService, RepositoryService repositoryService) {
        this.i18nService = i18nService;
        this.projectService = projectService;
        this.repositoryService = repositoryService;
    }

    @Override
    @Nonnull
    public Repository doGetValue(HttpContext httpContext) {
        String repositorySlug;
        String projectKey = HttpContextUtils.requireSinglePathSegmentValue("projectKey", httpContext, Project.class);
        Repository repository = this.repositoryService.getBySlug(projectKey, repositorySlug = HttpContextUtils.requireSinglePathSegmentValue("repositorySlug", httpContext, Repository.class));
        if (repository == null) {
            Project project = this.projectService.getByKey(projectKey);
            if (project == null) {
                throw new NoSuchProjectException(this.i18nService.createKeyedMessage("stash.rest.nosuchproject", new Object[]{projectKey}));
            }
            throw new NoSuchRepositoryException(this.i18nService.createKeyedMessage("stash.rest.nosuchrepo", new Object[]{projectKey, repositorySlug}), project);
        }
        return repository;
    }
}

