/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.inject;

import com.atlassian.stash.internal.rest.annotations.OptionalContext;
import com.atlassian.stash.internal.rest.inject.AbstractResourceInjectable;
import com.sun.jersey.api.container.MappableContainerException;
import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.core.spi.component.ComponentContext;
import com.sun.jersey.core.spi.component.ComponentScope;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.inject.Injectable;
import com.sun.jersey.spi.inject.InjectableProvider;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.MessageBodyReader;

public class OptionalContextInjectableProvider
implements InjectableProvider<OptionalContext, Type> {
    public Injectable getInjectable(ComponentContext ic, OptionalContext optionalBody, Type type) {
        ParameterizedType genericType;
        if (type instanceof ParameterizedType && Map.class.equals((Object)(genericType = (ParameterizedType)type).getRawType())) {
            return new OptionalContextInjectable(genericType);
        }
        return null;
    }

    public ComponentScope getScope() {
        return ComponentScope.Singleton;
    }

    private static class OptionalContextInjectable
    extends AbstractResourceInjectable<Map<String, Object>> {
        private final Type genericType;

        private OptionalContextInjectable(Type genericType) {
            this.genericType = genericType;
        }

        @Override
        protected Map<String, Object> doGetValue(HttpContext httpContext) {
            ContainerRequest request = (ContainerRequest)httpContext.getRequest();
            String context = (String)request.getQueryParameters(true).getFirst((Object)"context");
            if (context == null) {
                return Collections.emptyMap();
            }
            MessageBodyReader reader = request.getMessageBodyWorkers().getMessageBodyReader(Map.class, this.genericType, EMPTY_ANNOTATIONS, MediaType.APPLICATION_JSON_TYPE);
            try {
                return (Map)reader.readFrom(Map.class, this.genericType, EMPTY_ANNOTATIONS, MediaType.APPLICATION_JSON_TYPE, request.getRequestHeaders(), (InputStream)new ByteArrayInputStream(context.getBytes(StandardCharsets.UTF_8)));
            }
            catch (IOException e) {
                throw new MappableContainerException((Throwable)e);
            }
        }
    }
}

