/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.filter;

import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerResponse;
import com.sun.jersey.spi.container.ContainerResponseFilter;
import java.io.IOException;
import java.io.OutputStream;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;

public class StreamingOutputResponseFilter
implements ContainerResponseFilter {
    public ContainerResponse filter(ContainerRequest request, ContainerResponse response) {
        Object entity = response.getEntity();
        if (entity instanceof StreamingOutput) {
            response.setEntity((Object)new ExceptionMappingStreamingOutput(response, (StreamingOutput)entity));
        }
        return response;
    }

    private static class ExceptionMappingStreamingOutput
    implements StreamingOutput {
        private final StreamingOutput delegate;
        private final ContainerResponse response;

        private ExceptionMappingStreamingOutput(ContainerResponse response, StreamingOutput delegate) {
            this.delegate = delegate;
            this.response = response;
        }

        public void write(OutputStream output) throws IOException, WebApplicationException {
            try {
                this.delegate.write(output);
            }
            catch (RuntimeException e) {
                if (this.response.isCommitted() || !this.response.mapException((Throwable)e)) {
                    throw e;
                }
                this.response.write();
            }
        }
    }
}

