/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.content;

import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.comment.DiffCommentAnchor;
import com.atlassian.bitbucket.content.AbstractDiffContentCallback;
import com.atlassian.bitbucket.content.ConflictMarker;
import com.atlassian.bitbucket.content.DiffContext;
import com.atlassian.bitbucket.content.DiffSegmentType;
import com.atlassian.bitbucket.content.DiffSummary;
import com.atlassian.bitbucket.content.Path;
import com.atlassian.bitbucket.rest.comment.RestComment;
import com.atlassian.bitbucket.rest.content.RestPath;
import com.atlassian.bitbucket.rest.util.StatefulJsonWriter;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.collections.CollectionUtils;

public class JsonDiffContentCallback
extends AbstractDiffContentCallback {
    private final Function<Comment, RestComment> commentTransformer;
    private final List<Comment> fileComments;
    private final Map<DiffSegmentType, Map<Integer, List<DiffCommentAnchor>>> lineAnchorsByType;
    private final List<Comment> lineComments;
    private final StatefulJsonWriter writer;
    private int currentDestinationLine;
    private Map<Integer, List<DiffCommentAnchor>> currentSegmentAnchors;
    private DiffSegmentType currentSegmentType;
    private int currentSourceLine;

    public JsonDiffContentCallback(StatefulJsonWriter writer, Function<Comment, RestComment> commentTransformer) {
        this.commentTransformer = commentTransformer;
        this.writer = writer;
        this.fileComments = Lists.newArrayList();
        this.lineAnchorsByType = Maps.newEnumMap(DiffSegmentType.class);
        this.lineComments = Lists.newArrayList();
    }

    public void offerAnchors(@Nonnull List<DiffCommentAnchor> anchors) throws IOException {
        if (CollectionUtils.isEmpty(anchors)) {
            return;
        }
        for (DiffCommentAnchor anchor : anchors) {
            List lineAnchors;
            if (anchor.isFileComment()) {
                this.fileComments.add(anchor.getComment());
                continue;
            }
            HashMap anchorsByLine = this.lineAnchorsByType.get(anchor.getLineType());
            if (anchorsByLine == null) {
                anchorsByLine = Maps.newHashMap();
                this.lineAnchorsByType.put(anchor.getLineType(), anchorsByLine);
            }
            if ((lineAnchors = (List)anchorsByLine.get(anchor.getLine())) == null) {
                lineAnchors = Lists.newArrayList();
                anchorsByLine.put(anchor.getLine(), lineAnchors);
            }
            lineAnchors.add(anchor);
            this.lineComments.add(anchor.getComment());
        }
    }

    public void onBinary(Path src, Path dst) throws IOException {
        this.startDiff(src, dst);
        this.writer.name("binary").value(true);
        this.writeComments("fileComments", this.fileComments);
        this.writer.endObject();
    }

    public void onDiffEnd(boolean truncated) throws IOException {
        this.writer.endArray();
        this.writer.name("truncated").value(truncated);
        this.writeComments("fileComments", this.fileComments);
        this.writeComments("lineComments", this.lineComments);
        this.writer.endObject();
    }

    public void onDiffStart(Path src, Path dst) throws IOException {
        this.startDiff(src, dst);
        this.writer.name("hunks");
        this.writer.beginArray();
    }

    public void onEnd(@Nonnull DiffSummary summary) throws IOException {
        this.writer.endArray().endObject();
    }

    public void onHunkEnd(boolean truncated) throws IOException {
        this.writer.endArray();
        this.writer.name("truncated").value(truncated);
        this.writer.endObject();
    }

    public void onHunkStart(int srcLine, int srcSpan, int dstLine, int dstSpan) throws IOException {
        this.currentSourceLine = srcLine;
        this.currentDestinationLine = dstLine;
        this.writer.beginObject();
        this.writer.name("sourceLine").value(srcLine);
        this.writer.name("sourceSpan").value(srcSpan);
        this.writer.name("destinationLine").value(dstLine);
        this.writer.name("destinationSpan").value(dstSpan);
        this.writer.name("segments");
        this.writer.beginArray();
    }

    public void onSegmentEnd(boolean truncated) throws IOException {
        this.currentSegmentAnchors = null;
        this.currentSegmentType = null;
        this.writer.endArray();
        this.writer.name("truncated").value(truncated);
        this.writer.endObject();
    }

    public void onSegmentLine(@Nonnull String line, ConflictMarker marker, boolean truncated) throws IOException {
        int sourceLine = this.currentSourceLine;
        int destinationLine = this.currentDestinationLine;
        int commentLine = this.chooseCommentLineAndIncrementLines();
        this.writer.beginObject();
        this.writer.name("source").value(sourceLine);
        this.writer.name("destination").value(destinationLine);
        this.writer.name("line").value(line);
        this.writer.name("truncated").value(truncated);
        if (marker != null) {
            this.writer.name("conflictMarker").value(marker);
        }
        if (this.currentSegmentAnchors != null && this.currentSegmentAnchors.containsKey(commentLine)) {
            List<DiffCommentAnchor> anchors = this.currentSegmentAnchors.get(commentLine);
            this.writer.name("commentIds");
            this.writer.beginArray();
            for (DiffCommentAnchor anchor : anchors) {
                Comment comment = anchor.getComment();
                this.writer.value(comment.getId());
            }
            this.writer.endArray();
        }
        this.writer.endObject();
    }

    public void onSegmentStart(@Nonnull DiffSegmentType type) throws IOException {
        this.currentSegmentAnchors = this.lineAnchorsByType.get(type);
        this.currentSegmentType = type;
        this.writer.beginObject();
        this.writer.name("type").value(type.name());
        this.writer.name("lines");
        this.writer.beginArray();
    }

    public void onStart(@Nonnull DiffContext context) throws IOException {
        this.writer.beginObject().name("fromHash").value(context.getFromHash()).name("toHash").value(context.getToHash()).name("contextLines").value(context.getContextLines()).name("whitespace").value(context.getWhitespace().name()).name("diffs").beginArray();
    }

    private int chooseCommentLineAndIncrementLines() {
        switch (this.currentSegmentType) {
            case ADDED: {
                return this.currentDestinationLine++;
            }
            case CONTEXT: {
                ++this.currentDestinationLine;
            }
        }
        return this.currentSourceLine++;
    }

    private void startDiff(Path src, Path dst) throws IOException {
        this.writer.beginObject();
        this.writePath("source", src);
        this.writePath("destination", dst);
    }

    private void writeComments(String name, List<Comment> comments) throws IOException {
        if (CollectionUtils.isNotEmpty(comments)) {
            this.writer.name(name);
            this.writer.beginArray();
            for (Comment comment : comments) {
                this.writer.value(this.commentTransformer.apply((Object)comment));
            }
            this.writer.endArray();
        }
    }

    private void writePath(String name, Path path) throws IOException {
        this.writer.name(name);
        if (path == null) {
            this.writer.nullValue();
        } else {
            this.writer.value(new RestPath(path));
        }
    }
}

