/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.content;

import com.atlassian.bitbucket.commit.CommitService;
import com.atlassian.bitbucket.content.ChangeCallback;
import com.atlassian.bitbucket.content.ChangesRequest;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.BadRequestException;
import com.atlassian.bitbucket.rest.RestResource;
import com.atlassian.bitbucket.rest.util.CachePolicies;
import com.atlassian.bitbucket.rest.util.JsonStreamingOutput;
import com.atlassian.bitbucket.rest.util.ResponseFactory;
import com.atlassian.bitbucket.rest.util.StatefulJsonWriter;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.stash.internal.rest.content.JsonChangeCallback;
import com.sun.jersey.spi.resource.Singleton;
import java.io.IOException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;

@AnonymousAllowed
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/changes")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class ChangeResource
extends RestResource {
    private final CommitService commitService;
    private final NavBuilder navBuilder;

    public ChangeResource(I18nService i18nService, CommitService commitService, NavBuilder navBuilder) {
        super(i18nService);
        this.commitService = commitService;
        this.navBuilder = navBuilder;
    }

    @GET
    public Response getChanges(@Context Repository repository, @QueryParam(value="since") String parentId, @QueryParam(value="until") String commitId, final @Context PageRequest pageRequest) {
        if (StringUtils.isBlank((String)commitId)) {
            throw new BadRequestException(this.i18nService.getMessage("stash.rest.until.required", new Object[0]));
        }
        final ChangesRequest request = new ChangesRequest.Builder(repository, commitId).sinceId(parentId).withComments(false).build();
        final NavBuilder.Commit commitNav = this.navBuilder.repo(repository).commit(commitId);
        return ResponseFactory.ok(new JsonStreamingOutput(){

            @Override
            public void write(StatefulJsonWriter writer) throws IOException, WebApplicationException {
                ChangeResource.this.commitService.streamChanges(request, (ChangeCallback)new JsonChangeCallback(writer, pageRequest, commitNav));
            }
        }, CachePolicies.getCacheControlForRange(commitId, parentId)).build();
    }
}

