/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.compare;

import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.commit.CommitCallback;
import com.atlassian.bitbucket.compare.CompareDiffRequest;
import com.atlassian.bitbucket.compare.CompareRef;
import com.atlassian.bitbucket.compare.CompareRequest;
import com.atlassian.bitbucket.compare.CompareService;
import com.atlassian.bitbucket.content.ChangeCallback;
import com.atlassian.bitbucket.content.DiffContentCallback;
import com.atlassian.bitbucket.content.DiffContentFilter;
import com.atlassian.bitbucket.content.DiffWhitespace;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.NoDefaultBranchException;
import com.atlassian.bitbucket.repository.NoSuchRepositoryException;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.rest.RestResource;
import com.atlassian.bitbucket.rest.comment.RestComment;
import com.atlassian.bitbucket.rest.commit.RestCommit;
import com.atlassian.bitbucket.rest.enrich.AvatarEnricher;
import com.atlassian.bitbucket.rest.util.CachePolicies;
import com.atlassian.bitbucket.rest.util.JsonStreamingOutput;
import com.atlassian.bitbucket.rest.util.ResponseFactory;
import com.atlassian.bitbucket.rest.util.RestUtils;
import com.atlassian.bitbucket.rest.util.StatefulJsonWriter;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.stash.internal.rest.content.JsonChangeCallback;
import com.atlassian.stash.internal.rest.content.JsonDiffContentCallback;
import com.atlassian.stash.internal.rest.pull.JsonCommitCallback;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.primitives.Ints;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.resource.Singleton;
import java.io.IOException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;

@AnonymousAllowed
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/compare")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class CompareResource
extends RestResource {
    private final AvatarEnricher avatarEnricher;
    private final CompareService compareService;
    private final RefService refService;
    private final RepositoryService repositoryService;

    public CompareResource(AvatarEnricher avatarEnricher, CompareService compareService, I18nService i18nService, RefService refService, RepositoryService repositoryService) {
        super(i18nService);
        this.avatarEnricher = avatarEnricher;
        this.compareService = compareService;
        this.refService = refService;
        this.repositoryService = repositoryService;
    }

    @GET
    @Path(value="/changes")
    public Response streamChanges(@Context Repository repository, @QueryParam(value="from") String from, @QueryParam(value="to") String to, @QueryParam(value="fromRepo") @DefaultValue(value="") String fromRepo, final @Context PageRequest pageRequest) {
        final CompareRequest compareRequest = this.toCompareRequest(from, fromRepo, to, repository);
        return ResponseFactory.ok(new JsonStreamingOutput(){

            @Override
            public void write(StatefulJsonWriter writer) throws IOException, WebApplicationException {
                CompareResource.this.compareService.streamChanges(compareRequest, (ChangeCallback)new JsonChangeCallback(writer, pageRequest));
            }
        }, this.compareCachePolicy(compareRequest)).build();
    }

    @GET
    @Path(value="/commits")
    public Response streamCommits(@Context Repository repository, @QueryParam(value="from") String from, @QueryParam(value="to") String to, @QueryParam(value="fromRepo") @DefaultValue(value="") String fromRepo, final @Context PageRequest pageRequest, final @Context ContainerRequest request) {
        final CompareRequest compareRequest = this.toCompareRequest(from, fromRepo, to, repository);
        return ResponseFactory.ok(new JsonStreamingOutput(){

            @Override
            public void write(StatefulJsonWriter writer) throws IOException, WebApplicationException {
                CompareResource.this.compareService.streamCommits(compareRequest, (CommitCallback)new JsonCommitCallback(writer, RestCommit.createTransformer(request, CompareResource.this.avatarEnricher), false, pageRequest));
            }
        }).build();
    }

    @GET
    @Path(value="/diff{path:.*}")
    public Response streamDiff(@Context Repository repository, @QueryParam(value="from") String from, @QueryParam(value="to") String to, @QueryParam(value="fromRepo") @DefaultValue(value="") String fromRepo, @PathParam(value="path") String path, @QueryParam(value="srcPath") String srcPath, @QueryParam(value="contextLines") @DefaultValue(value="-1") int contextLines, @QueryParam(value="whitespace") String whitespace, @Context DiffContentFilter filter, @Context ContainerRequest request) {
        path = StringUtils.removeStart((String)path, (String)"/");
        Repository fromRepository = this.getSourceRepository(fromRepo, repository);
        final CompareDiffRequest compareRequest = ((CompareDiffRequest.Builder)((CompareDiffRequest.Builder)((CompareDiffRequest.Builder)((CompareDiffRequest.Builder)new CompareDiffRequest.Builder().fromRef(this.toCompareRef(from, fromRepository)).filter(filter)).toRef(this.toCompareRef(to, repository)).paths(path, new String[]{srcPath})).contextLines(contextLines)).whitespace(DiffWhitespace.fromString((String)whitespace))).build();
        return ResponseFactory.ok(new JsonStreamingOutput(){

            @Override
            public void write(StatefulJsonWriter writer) throws IOException, WebApplicationException {
                Function<Comment, RestComment> commentTransformer = RestComment.REST_TRANSFORM;
                CompareResource.this.compareService.streamDiff(compareRequest, (DiffContentCallback)new JsonDiffContentCallback(writer, commentTransformer));
            }
        }, this.compareCachePolicy(compareRequest)).build();
    }

    private CacheControl getCacheControl(CompareRef fromRef, CompareRef toRef) {
        return RestUtils.isImmutableObjectId(fromRef.getId()) && RestUtils.isImmutableObjectId(toRef.getId()) ? CachePolicies.cacheForAMonth() : CachePolicies.noCache();
    }

    private CacheControl compareCachePolicy(CompareRequest compareRequest) {
        return this.getCacheControl(compareRequest.getFromRef(), compareRequest.getToRef());
    }

    private CacheControl compareCachePolicy(CompareDiffRequest compareDiffRequest) {
        return this.getCacheControl(compareDiffRequest.getFromRef(), compareDiffRequest.getToRef());
    }

    private Repository getSourceRepository(String fromRepo, Repository toRepository) {
        Repository repository;
        if (Strings.isNullOrEmpty((String)fromRepo)) {
            repository = toRepository;
        } else {
            Integer repositoryId = Ints.tryParse((String)fromRepo);
            if (repositoryId != null) {
                repository = this.repositoryService.getById(repositoryId.intValue());
                if (repository == null) {
                    throw new NoSuchRepositoryException(this.i18nService.createKeyedMessage("stash.rest.nosuchrepo.secondarybyid", new Object[]{repositoryId}), null);
                }
            } else {
                String repositorySlug;
                int p = fromRepo.indexOf(47);
                String projectKey = StringUtils.substring((String)fromRepo, (int)0, (int)p);
                repository = this.repositoryService.getBySlug(projectKey, repositorySlug = StringUtils.substring((String)fromRepo, (int)(p + 1)));
                if (repository == null) {
                    throw new NoSuchRepositoryException(this.i18nService.createKeyedMessage("stash.rest.nosuchrepo.secondarybyslug", new Object[]{projectKey, repositorySlug}), null);
                }
            }
        }
        return repository;
    }

    private CompareRef toCompareRef(String id, Repository repository) {
        if (StringUtils.isBlank((String)id)) {
            try {
                id = this.refService.getDefaultBranch(repository).getId();
            }
            catch (NoDefaultBranchException noDefaultBranchException) {
                // empty catch block
            }
        }
        return new CompareRef(id, repository);
    }

    private CompareRequest toCompareRequest(String from, String fromRepositoryId, String to, Repository toRepository) {
        Repository fromRepository = this.getSourceRepository(fromRepositoryId, toRepository);
        return new CompareRequest.Builder().fromRef(this.toCompareRef(from, fromRepository)).toRef(this.toCompareRef(to, toRepository)).build();
    }
}

