/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.commit;

import com.atlassian.bitbucket.commit.CommitService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.util.ResponseFactory;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.sun.jersey.spi.resource.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@AnonymousAllowed
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/watch")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class CommitWatchResource {
    private final CommitService commitService;

    public CommitWatchResource(CommitService commitService) {
        this.commitService = commitService;
    }

    @POST
    public Response watch(@Context Repository repository, @PathParam(value="commitId") String commitId) {
        this.commitService.watch(repository, commitId);
        return ResponseFactory.noContent().build();
    }

    @DELETE
    public Response unwatch(@Context Repository repository, @PathParam(value="commitId") String commitId) {
        this.commitService.unwatch(repository, commitId);
        return ResponseFactory.noContent().build();
    }
}

