/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.commit;

import com.atlassian.bitbucket.avatar.AvatarRequest;
import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.commit.CommitService;
import com.atlassian.bitbucket.content.DiffContentCallback;
import com.atlassian.bitbucket.content.DiffContentFilter;
import com.atlassian.bitbucket.content.DiffRequest;
import com.atlassian.bitbucket.content.DiffWhitespace;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.RestResource;
import com.atlassian.bitbucket.rest.comment.RestComment;
import com.atlassian.bitbucket.rest.enrich.AvatarEnricher;
import com.atlassian.bitbucket.rest.util.CachePolicies;
import com.atlassian.bitbucket.rest.util.JsonStreamingOutput;
import com.atlassian.bitbucket.rest.util.ResponseFactory;
import com.atlassian.bitbucket.rest.util.RestUtils;
import com.atlassian.bitbucket.rest.util.StatefulJsonWriter;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.stash.internal.rest.content.JsonDiffContentCallback;
import com.google.common.base.Function;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.resource.Singleton;
import java.io.IOException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;

@AnonymousAllowed
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/commits/{commitId}/diff")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class CommitDiffResource
extends RestResource {
    private final AvatarEnricher avatarEnricher;
    private final CommitService commitService;

    public CommitDiffResource(I18nService i18nService, AvatarEnricher avatarEnricher, CommitService commitService) {
        super(i18nService);
        this.avatarEnricher = avatarEnricher;
        this.commitService = commitService;
    }

    @GET
    @Path(value="{path:.*}")
    public Response streamDiff(@Context Repository repository, @PathParam(value="commitId") String untilId, @PathParam(value="path") String path, @QueryParam(value="contextLines") @DefaultValue(value="-1") int contextLines, @QueryParam(value="since") String sinceId, @QueryParam(value="srcPath") String srcPath, @QueryParam(value="whitespace") String whitespace, @QueryParam(value="withComments") @DefaultValue(value="true") boolean withComments, @Context DiffContentFilter filter, @Context ContainerRequest request) {
        DiffRequest.Builder builder = ((DiffRequest.Builder)new DiffRequest.Builder(repository, untilId).contextLines(contextLines).filter(filter)).path(path).sinceId(sinceId).whitespace(DiffWhitespace.fromString((String)whitespace)).withComments(withComments);
        if (StringUtils.isNotBlank((String)srcPath)) {
            builder.path(srcPath);
        }
        final DiffRequest diffRequest = builder.build();
        final Function<Comment, RestComment> commentTransformer = this.createAvatarCommentTransformer(request);
        return ResponseFactory.ok(new JsonStreamingOutput(){

            @Override
            public void write(StatefulJsonWriter writer) throws IOException, WebApplicationException {
                CommitDiffResource.this.commitService.streamDiff(diffRequest, (DiffContentCallback)new JsonDiffContentCallback(writer, (Function<Comment, RestComment>)commentTransformer));
            }
        }, withComments ? CachePolicies.noCache() : CachePolicies.getCacheControlForRange(untilId, sinceId)).build();
    }

    @GET
    public Response streamDiff(@Context Repository repository, @PathParam(value="commitId") String untilId, @QueryParam(value="contextLines") @DefaultValue(value="-1") int contextLines, @QueryParam(value="since") String sinceId, @QueryParam(value="srcPath") String srcPath, @QueryParam(value="whitespace") String whitespace, @QueryParam(value="withComments") @DefaultValue(value="true") boolean withComments, @Context DiffContentFilter filter, @Context ContainerRequest request) {
        return this.streamDiff(repository, untilId, null, contextLines, sinceId, srcPath, whitespace, withComments, filter, request);
    }

    private Function<Comment, RestComment> createAvatarCommentTransformer(ContainerRequest request) {
        final AvatarRequest avatarRequest = RestUtils.makeAvatarRequest(request);
        if (avatarRequest == null) {
            return RestComment.REST_TRANSFORM;
        }
        return new Function<Comment, RestComment>(){

            public RestComment apply(Comment comment) {
                RestComment restComment = new RestComment(comment, this);
                CommitDiffResource.this.avatarEnricher.enrich(restComment, avatarRequest);
                return restComment;
            }
        };
    }
}

