/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.repository;

import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.Tag;
import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.rest.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.repository.RestBranch;
import com.atlassian.bitbucket.rest.repository.RestRef;
import com.atlassian.bitbucket.rest.repository.RestTag;
import com.google.common.base.Function;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=MinimalRef.class)
public class RestMinimalRef
extends RestMapEntity {
    public static final String DISPLAY_ID = "displayId";
    public static final String ID = "id";
    public static final Function<MinimalRef, RestMinimalRef> REST_TRANSFORM = new Function<MinimalRef, RestMinimalRef>(){

        public RestMinimalRef apply(MinimalRef ref) {
            if (ref == null) {
                return null;
            }
            if (ref instanceof Branch) {
                return new RestBranch((Branch)ref);
            }
            if (ref instanceof Tag) {
                return new RestTag((Tag)ref);
            }
            return ref instanceof Ref ? new RestRef((Ref)ref) : new RestMinimalRef(ref);
        }
    };

    public RestMinimalRef() {
    }

    public RestMinimalRef(MinimalRef ref) {
        this(ref.getId(), ref.getDisplayId());
    }

    protected RestMinimalRef(String id, String displayId) {
        this.put(ID, id);
        this.put(DISPLAY_ID, displayId);
    }

    public String getId() {
        return this.getStringProperty(ID);
    }
}

