/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.repository.ref.restriction;

import com.atlassian.bitbucket.audit.AuditEntry;
import com.atlassian.bitbucket.audit.AuditEntryBuilder;
import com.atlassian.bitbucket.audit.AuditEntryConverter;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.ref.restriction.RefRestrictionEvent;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.security.Principal;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import org.codehaus.jackson.map.ObjectMapper;

public class RefRestrictionEventConverter
implements AuditEntryConverter<RefRestrictionEvent> {
    private static final ObjectMapper objectMapperInstance = new ObjectMapper();

    @Nonnull
    public AuditEntry convert(@Nonnull RefRestrictionEvent event, AuditEntryBuilder builder) {
        List<String> affectedGroups;
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder().put((Object)"id", (Object)event.getRestriction().getId()).put((Object)"type", (Object)event.getRestriction().getType().getId()).put((Object)"matcher", (Object)event.getRestriction().getMatcher().getId()).put((Object)"matcherType", (Object)event.getRestriction().getMatcher().getType().getDisplayId());
        List<ApplicationUser> affectedUsers = event.getAffectedUsers();
        if (!affectedUsers.isEmpty()) {
            mapBuilder.put((Object)"users", (Object)Collections2.transform(affectedUsers, Principal::getName));
        }
        if (!(affectedGroups = event.getAffectedGroups()).isEmpty()) {
            mapBuilder.put((Object)"groups", affectedGroups);
        }
        ImmutableMap map = mapBuilder.build();
        try {
            return builder.action(((Object)((Object)event)).getClass()).timestamp(new Date()).details(objectMapperInstance.writeValueAsString((Object)map)).user(event.getUser()).target(RefRestrictionEventConverter.toProjectAndRepositoryString(event.getRepository())).repository(event.getRepository()).build();
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to convert map %s to JSON", map), e);
        }
    }

    private static String toProjectAndRepositoryString(@Nonnull Repository repository) {
        return repository.getProject().getKey() + "/" + repository.getSlug();
    }
}

