/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.repository.ref.restriction;

import com.atlassian.bitbucket.audit.Priority;
import com.atlassian.bitbucket.event.annotation.Audited;
import com.atlassian.bitbucket.event.annotation.TransactionAware;
import com.atlassian.bitbucket.event.repository.RepositoryEvent;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.ref.restriction.RefRestriction;
import com.atlassian.bitbucket.repository.ref.restriction.RefRestrictionEventConverter;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;

@TransactionAware
@Audited(converter=RefRestrictionEventConverter.class, channels={"audit.channel.ui.repository"}, priority=Priority.HIGH)
public abstract class RefRestrictionEvent
extends RepositoryEvent {
    private final List<String> affectedGroups;
    private final List<ApplicationUser> affectedUsers;
    private final RefRestriction restriction;

    public RefRestrictionEvent(@Nonnull Object source, @Nonnull Repository repository, @Nonnull RefRestriction restriction, @Nonnull Collection<ApplicationUser> affectedUsers, @Nonnull Collection<String> affectedGroups) {
        super(source, repository);
        this.affectedGroups = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(affectedGroups, (Object)"affectedGroups")));
        this.affectedUsers = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(affectedUsers, (Object)"affectedUsers")));
        this.restriction = (RefRestriction)Preconditions.checkNotNull((Object)restriction, (Object)"restriction");
    }

    @Nonnull
    public List<String> getAffectedGroups() {
        return this.affectedGroups;
    }

    @Nonnull
    public List<ApplicationUser> getAffectedUsers() {
        return this.affectedUsers;
    }

    @Nonnull
    public RefRestriction getRestriction() {
        return this.restriction;
    }
}

