/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.webhook;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.page.webhook.BaseWebhookPage;
import com.atlassian.webdriver.bitbucket.page.webhook.ProjectWebhookCreatePage;
import com.atlassian.webdriver.bitbucket.page.webhook.ProjectWebhookRow;
import java.util.List;
import java.util.stream.Collectors;
import org.openqa.selenium.By;

public class ProjectWebhookPage
extends BaseWebhookPage {
    private final String projectKey;
    @ElementBy(cssSelector="#webhooks-container .aui-button.aui-button-primary, #webhooks-container .aui-button-primary")
    private PageElement createWebhookButton;
    @ElementBy(className="empty-banner-content")
    private PageElement emptyMessage;

    public ProjectWebhookPage(String projectKey) {
        this.projectKey = projectKey;
    }

    public String getUrl() {
        return String.format("/plugins/servlet/webhooks/projects/%s/", this.projectKey);
    }

    public ProjectWebhookCreatePage createWebhook() {
        this.createWebhookButton.click();
        return (ProjectWebhookCreatePage)this.pageBinder.bind(ProjectWebhookCreatePage.class, new Object[]{this.projectKey});
    }

    public void delete(ProjectWebhookRow webhook) {
        webhook.delete();
        PageElement deleteDialog = this.elementFinder.find(By.cssSelector((String)"[data-testid='webhook-delete-modal']"));
        Poller.waitUntilTrue((TimedQuery)deleteDialog.timed().isVisible());
        PageElement deleteButton = deleteDialog.find(By.className((String)"webhook-delete-dialog-delete-button"));
        Poller.waitUntilTrue((TimedQuery)deleteButton.timed().isVisible());
        deleteButton.click();
    }

    public List<ProjectWebhookRow> getWebhooks() {
        return this.webhooksTable.findAll(By.tagName((String)"tr")).stream().map(tr -> (ProjectWebhookRow)this.pageBinder.bind(ProjectWebhookRow.class, new Object[]{tr})).collect(Collectors.toList());
    }

    public TimedCondition isEmptyState() {
        return this.emptyMessage.timed().isVisible();
    }
}

