/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.search;

import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.page.search.SearchResultsPage;
import com.google.inject.Inject;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;

public class QuickSearch {
    @Inject
    private PageBinder pageBinder;
    @ElementBy(id="quick-search")
    private PageElement searchInput;

    public void click() {
        this.searchInput.click();
    }

    public SearchResultsPage quickCodeSearch(String query) {
        this.searchInput.clear();
        this.searchInput.type(new CharSequence[]{query + "\n"});
        return (SearchResultsPage)this.pageBinder.bind(SearchResultsPage.class, new Object[0]);
    }

    public QuickSearchResultList quickSearch(String query) {
        this.searchInput.clear();
        this.searchInput.type(new CharSequence[]{query});
        return (QuickSearchResultList)this.pageBinder.bind(QuickSearchResultList.class, new Object[]{this.searchInput});
    }

    public static class QuickSearchResultList {
        @ElementBy(id="quick-search-dialog")
        protected PageElement quickSearchDialog;
        private final PageElement searchInput;

        public QuickSearchResultList(PageElement searchInput) {
            this.searchInput = searchInput;
        }

        public QuickSearchResultList click(QuickSearchItem item) {
            PageElement element = this.quickSearchDialog.find(By.cssSelector((String)item.getCssSelector()));
            if (!element.isPresent()) {
                throw new AssertionError((Object)("Unable to find quick search item with css selector '" + item.getCssSelector() + "'"));
            }
            element.click();
            return this;
        }

        public QuickSearchResultList focusNext() {
            this.searchInput.type(new CharSequence[]{Keys.ARROW_DOWN});
            return this;
        }

        public QuickSearchResultList focusPrevious() {
            this.searchInput.type(new CharSequence[]{Keys.ARROW_UP});
            return this;
        }

        public List<CommitItem> getCommitResults() {
            return this.getQuickSearchResults(".commit-link", e -> new CommitItem(e.getAttribute("data-commit-id")));
        }

        public List<RepositoryItem> getRepositoryResults() {
            return this.getQuickSearchResults(".repository-link", e -> new RepositoryItem(e.getAttribute("data-project-key"), e.getAttribute("data-repository-slug")));
        }

        @WaitUntil
        public void ready() {
            this.waitForQuickSearchResults(".quick-search-results li");
        }

        public void selectFocused() {
            this.quickSearchDialog.find(By.cssSelector((String)".quick-search-results .focused > a")).click();
        }

        public void waitForCommitResults() {
            this.waitForQuickSearchResults(".quick-search-results li.commit");
        }

        public void waitForRepositoryResults() {
            this.waitForQuickSearchResults(".quick-search-results li.repository");
        }

        private <T> List<T> getQuickSearchResults(String cssSelector, Function<PageElement, T> resultMapper) {
            List resultElements = this.quickSearchDialog.findAll(By.cssSelector((String)cssSelector));
            return resultElements.stream().map(resultMapper).collect(Collectors.toList());
        }

        private void waitForQuickSearchResults(String s) {
            Poller.waitUntilTrue((TimedQuery)this.quickSearchDialog.find(By.cssSelector((String)s)).timed().isVisible());
        }
    }

    public static class RepositoryItem
    implements QuickSearchItem {
        private final String projectKey;
        private final String repoSlug;

        public RepositoryItem(String projectKey, String repoSlug) {
            this.projectKey = projectKey;
            this.repoSlug = repoSlug;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RepositoryItem that = (RepositoryItem)o;
            return Objects.equals(this.projectKey, that.projectKey) && Objects.equals(this.repoSlug, that.repoSlug);
        }

        @Override
        public String getCssSelector() {
            return String.format(".quick-search-results li.repository [data-repository-slug=\"%s\"][data-project-key=\"%s\"]", this.repoSlug, this.projectKey);
        }

        public int hashCode() {
            return Objects.hash(this.projectKey, this.repoSlug);
        }

        public String toString() {
            return "RepositoryItem{projectKey='" + this.projectKey + "', repoSlug='" + this.repoSlug + "'}";
        }
    }

    public static class CommitItem
    implements QuickSearchItem {
        private final String commitHash;

        public CommitItem(String commitHash) {
            this.commitHash = commitHash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CommitItem that = (CommitItem)o;
            return Objects.equals(this.commitHash, that.commitHash);
        }

        @Override
        public String getCssSelector() {
            return String.format(".quick-search-results li.commit [data-commit-id=\"%s\"]", this.commitHash);
        }

        public int hashCode() {
            return Objects.hash(this.commitHash);
        }

        public String toString() {
            return "CommitItem{commitHash='" + this.commitHash + "'}";
        }
    }

    public static interface QuickSearchItem {
        public String getCssSelector();
    }
}

