/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin.repositorymanagement;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.testing.PageElementMatchers;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import java.util.List;
import javax.annotation.Nonnull;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.openqa.selenium.By;

public class LocationSelector
extends AbstractElementPageObject {
    private static final String ALL_REPOSITORIES = "All repositories";
    private static final String PROJECTS = "Projects";
    private static final String PERSONAL_ALL = "Personal (all users)";
    private static final String PERSONAL_ACTIVE = "Personal (active users)";
    private static final String PERSONAL_DELETED = "Personal (deleted users)";
    private static final String PUBLIC = "Public";

    public LocationSelector(@Nonnull PageElement container) {
        super(container);
    }

    public String getSelectedLocation() {
        return this.container.find(By.className((String)"location-filter__single-value")).getText();
    }

    public void selectAllRepositories() {
        this.selectLocation(ALL_REPOSITORIES);
    }

    public void selectProjects() {
        this.selectLocation(PROJECTS);
    }

    public void selectPersonalAll() {
        this.selectLocation(PERSONAL_ALL);
    }

    public void selectPersonalActive() {
        this.selectLocation(PERSONAL_ACTIVE);
    }

    public void selectPersonalDeleted() {
        this.selectLocation(PERSONAL_DELETED);
    }

    public void selectPublic() {
        this.selectLocation(PUBLIC);
    }

    private void selectLocation(String location) {
        this.container.click();
        ((List)Poller.waitUntil(this.getOptions(), (Matcher)CoreMatchers.hasItem((Matcher)PageElementMatchers.withText((String)location)))).stream().filter(p -> location.equals(p.getText())).findFirst().orElseThrow(() -> new AssertionError((Object)String.format("%s not found in the location selector drop-down", location))).click();
    }

    private TimedQuery<List<PageElement>> getOptions() {
        return Queries.forSupplier((Timeouts)this.timeouts, () -> this.container.findAll(By.className((String)"location-filter__option")));
    }
}

