/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin.defaulttasks.taskrow;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.page.admin.defaulttasks.dialog.AbstractDefaultTaskForm;
import com.atlassian.webdriver.bitbucket.page.admin.defaulttasks.dialog.DeleteDefaultTaskDialog;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.openqa.selenium.By;

public abstract class AbstractDefaultTaskRow
extends AbstractElementPageObject {
    @Inject
    private PageElementFinder elementFinder;

    protected AbstractDefaultTaskRow(@Nonnull PageElement container) {
        super(container);
    }

    public String getSourceBranch() {
        return this.container.find(By.cssSelector((String)"[data-testid='default-task-row-source-branch']")).getText();
    }

    public String getTargetBranch() {
        return this.container.find(By.cssSelector((String)"[data-testid='default-task-row-target-branch']")).getText();
    }

    public String getTaskDescription() {
        return this.container.find(By.cssSelector((String)".task-description > .truncate")).getText();
    }

    public AbstractDefaultTaskForm edit() {
        this.openActionsDropdown();
        PageElement editDropDownItem = this.elementFinder.find(By.cssSelector((String)"[data-testid='default-task-row-edit-action']"));
        Poller.waitUntilTrue((TimedQuery)editDropDownItem.timed().isVisible());
        editDropDownItem.click();
        return this.bindTaskDialog(this.container);
    }

    public DeleteDefaultTaskDialog delete() {
        this.openActionsDropdown();
        PageElement deleteDropdownItem = this.elementFinder.find(By.cssSelector((String)"[data-testid='default-task-row-delete-action']"));
        Poller.waitUntilTrue((TimedQuery)deleteDropdownItem.timed().isVisible());
        deleteDropdownItem.click();
        return (DeleteDefaultTaskDialog)this.pageBinder.bind(DeleteDefaultTaskDialog.class, new Object[0]);
    }

    public PageElement actionsDropdown() {
        return this.container.find(By.cssSelector((String)"[data-testid='default-task-row-more-actions-menu-button']"));
    }

    private void openActionsDropdown() {
        this.actionsDropdown().click();
    }

    public abstract AbstractDefaultTaskForm bindTaskDialog(@Nonnull PageElement var1);
}

