/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.webdriver.bitbucket.page.BitbucketPage;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import org.apache.http.client.utils.URIBuilder;
import org.springframework.web.util.UriUtils;

public class WebSudoPage
extends BitbucketPage {
    private final String nextUrl;
    @ElementBy(name="j_password")
    private PageElement passwordField;
    @ElementBy(cssSelector="button[type=submit]")
    private PageElement submitButton;
    @ElementBy(name="j_username")
    private PageElement usernameField;

    public WebSudoPage() {
        this(null);
    }

    public WebSudoPage(String nextUrl) {
        this.nextUrl = nextUrl;
    }

    public String getUrl() {
        try {
            URIBuilder uri = new URIBuilder("/websudo");
            if (this.nextUrl != null) {
                uri.addParameter("next", UriUtils.encodeQuery((String)("/mvc" + this.nextUrl), (String)StandardCharsets.UTF_8.name()));
            }
            return uri.build().toString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public String getUsername() {
        return this.usernameField.getValue();
    }

    public void submit(String adminPassword) {
        this.passwordField.clear().type(new CharSequence[]{adminPassword});
        this.submitButton.click();
    }
}

