/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;

public abstract class Menu<T extends Menu<T, I>, I> {
    private final PageElementFinder finder;
    private final PageElement trigger;
    private final String menuId;

    public Menu(PageElementFinder finder, By triggerSelector, String menuId) {
        this.finder = finder;
        this.trigger = finder.find(triggerSelector);
        this.menuId = menuId;
    }

    public T select(I item) {
        PageElement menu = this.openMenu();
        try {
            menu.findAll(By.tagName((String)"li")).stream().filter(Menu::isEnabled).filter(this.filterForItem(item)).findFirst().orElseThrow(Menu.illegalStateException("Unable to find menu for '%s'.", item)).click();
            if (!this.isSelected(item)) {
                throw new IllegalStateException(String.format("Clicking didn't select '%s'.", item));
            }
        }
        finally {
            this.closeMenu();
        }
        return this.self();
    }

    protected abstract Predicate<PageElement> filterForItem(I var1);

    protected abstract String getId();

    protected abstract boolean isSelected(I var1);

    protected abstract T self();

    protected static String text(PageElement element) {
        if (element == null) {
            return null;
        }
        return StringUtils.stripToNull((String)element.getText());
    }

    private static Supplier<RuntimeException> illegalStateException(String msg, Object ... args) {
        return () -> new IllegalStateException(String.format(msg, args));
    }

    private static boolean isEnabled(PageElement element) {
        return element.isEnabled() && Boolean.valueOf(element.getAttribute("disabled")) == false;
    }

    private void closeMenu() {
        if (this.isMenuOpen()) {
            this.trigger.click();
            if (this.isMenuOpen()) {
                throw new RuntimeException("Trigger did not close the menu.");
            }
        }
    }

    private PageElement getActiveListElement() {
        return this.finder.findAll(By.id((String)this.menuId)).stream().filter(PageElement::isVisible).findFirst().orElseThrow(Menu.illegalStateException("Unable to find menu '%s'", this.getId()));
    }

    protected String getSelected() {
        return this.trigger.getText();
    }

    private boolean isMenuOpen() {
        return this.finder.find(By.id((String)this.menuId)).isVisible();
    }

    private PageElement openMenu() {
        if (!this.isMenuOpen()) {
            this.trigger.click();
            if (!this.isMenuOpen()) {
                throw new RuntimeException("Trigger did not open the menu.");
            }
        }
        return this.getActiveListElement();
    }
}

