/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.accesstokens;

import com.atlassian.bitbucket.pageobjects.element.LoadingButton;
import com.atlassian.bitbucket.pageobjects.element.ReactSelect;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.page.accesstokens.AbstractAccessTokensPage;
import com.atlassian.webdriver.bitbucket.page.accesstokens.AccessTokenDisplay;
import javax.annotation.Nonnull;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.openqa.selenium.By;

public class AccessTokenForm
extends AbstractElementPageObject {
    private final PageElement disableExpiry = this.find(By.cssSelector((String)"[name='automatic-expiry'][value='false']"));
    private final PageElement enableExpiry = this.find(By.cssSelector((String)"[name='automatic-expiry'][value='true']"));
    private final PageElement expiryField = this.find(By.id((String)"access-token-expiry-days"));
    private final AbstractAccessTokensPage parentPage;
    private final PageElement saveButtonElement;
    private final PageElement tokenDisplay;
    private final PageElement tokenNameField;

    public AccessTokenForm(@Nonnull PageElement container, AbstractAccessTokensPage parentPage) {
        super(container);
        this.parentPage = parentPage;
        this.saveButtonElement = this.find(By.className((String)"save-button"));
        this.tokenDisplay = this.find(By.className((String)"access-token-display"));
        this.tokenNameField = this.find(By.id((String)"access-token-name"));
    }

    public boolean canDisableExpiry() {
        return this.disableExpiry.isPresent();
    }

    public AccessTokenDisplay create() {
        this.clickSave();
        return (AccessTokenDisplay)this.pageBinder.bind(AccessTokenDisplay.class, new Object[]{this.tokenDisplay, this.parentPage});
    }

    public AccessTokenForm disableExpiry() {
        this.disableExpiry.click();
        return this;
    }

    public AccessTokenForm enableExpiry() {
        this.enableExpiry.click();
        return this;
    }

    public String getExpiryDays() {
        return this.expiryField.getValue();
    }

    public AbstractAccessTokensPage save() {
        this.clickSave();
        return this.parentPage.rebind();
    }

    public AccessTokenForm setExpiry(String expiryDate) {
        this.expiryField.clear().type(new CharSequence[]{expiryDate});
        return this;
    }

    public AccessTokenForm setPermission(Permission permission) {
        String selectClassNamePrefix = permission.isResource(Project.class) ? "project-permissions" : "repo-permissions";
        ReactSelect select = (ReactSelect)this.pageBinder.bind(ReactSelect.class, new Object[]{this.container, selectClassNamePrefix});
        if (permission == Permission.PROJECT_ADMIN || permission == Permission.REPO_ADMIN) {
            select.selectOptionByPartialName("admin");
        } else if (permission == Permission.PROJECT_WRITE || permission == Permission.REPO_WRITE) {
            select.selectOptionByPartialName("write");
        } else {
            select.selectOptionByPartialName("read");
        }
        return this;
    }

    public AccessTokenForm setTokenName(String tokenName) {
        this.tokenNameField.clear().type(new CharSequence[]{tokenName});
        Poller.waitUntil((TimedQuery)this.tokenNameField.timed().getValue(), (Matcher)IsEqual.equalTo((Object)tokenName));
        return this;
    }

    private void clickSave() {
        LoadingButton saveButton = (LoadingButton)this.pageBinder.bind(LoadingButton.class, new Object[]{this.saveButtonElement});
        saveButton.click().waitUntilFinishedLoading();
    }
}

