/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.aui.auipageobjects.AuiCheckbox;
import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.OwnerOption;
import com.atlassian.webdriver.bitbucket.element.OwnerSelect;
import com.atlassian.webdriver.bitbucket.page.BitbucketPage;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import com.atlassian.webdriver.bitbucket.util.EventUtils;
import java.util.Optional;
import org.openqa.selenium.By;

public class RepositoryImportSelectPage
extends BitbucketPage {
    @ElementBy(id="s2id_repo-owners")
    private PageElement ownersSelector;
    @ElementBy(id="all-repositories")
    private AuiCheckbox allRepositoriesRadio;
    @ElementBy(id="select-repositories")
    private AuiCheckbox selectRepositoriesRadio;
    @ElementBy(id="import-repositories")
    private PageElement importButton;
    @ElementBy(name="cancel")
    private PageElement cancel;
    private final String projectKey;

    public RepositoryImportSelectPage(String projectKey) {
        this.projectKey = projectKey;
    }

    public String getUrl() {
        return "/plugins/servlet/import-repository/" + this.projectKey + "#select-repository";
    }

    public String getRepositoriesListErrorMessage() {
        return this.elementFinder.find(By.id((String)"repository-list")).find(By.className((String)"error")).getText();
    }

    public Long clickImport() {
        Poller.waitUntilTrue((TimedQuery)this.importButton.timed().isEnabled());
        EventUtils.waitUntilEventFired("bitbucket.internal.DO_NOT_USE.importer.job.created", () -> this.importButton.click(), this.javascriptExecutor, this.timeouts, TimeoutType.PAGE_LOAD);
        return (Long)this.javascriptExecutor.executeScript("return require('bitbucket-plugin-importer/internal/import-form/import-form')._getState().importing.jobId;", new Object[0]);
    }

    public RepositoryImportSelectPage clickSelectRepositories() {
        this.waitUntilEventFired("bitbucket.internal.DO_NOT_USE.importer.repository.list.dataLoaded", () -> this.selectRepositoriesRadio.click());
        return this;
    }

    public RepositoryImportSelectPage selectOwner(String ownerName) {
        Poller.waitUntilTrue((TimedQuery)this.ownersSelector.timed().isVisible());
        this.ownersSelector.click();
        OwnerSelect ownerSelect = (OwnerSelect)this.pageBinder.bind(OwnerSelect.class, new Object[]{this.ownersSelector});
        Optional<OwnerOption> ownerOption = MoreStreams.streamIterable((Iterable)((Iterable)ownerSelect.getOptions().now())).filter(option -> ownerName.equals(option.getText())).findFirst();
        ownerOption.ifPresent(ownerSelect::selectOption);
        return this;
    }

    public RepositoryImportSelectPage selectRepository(String repoName) {
        AuiCheckbox repoCheckBox = ElementUtils.findCheckbox(this.elementFinder, By.id((String)("repository-list-" + repoName)));
        Poller.waitUntilTrue((TimedQuery)repoCheckBox.timed().isVisible());
        repoCheckBox.click();
        return this;
    }
}

