/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.webdriver.bitbucket.element.IdSelect2;
import com.atlassian.webdriver.bitbucket.element.TimeZoneOption;
import java.time.ZoneId;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class TimeZoneSelector
extends IdSelect2<TimeZoneSelector, TimeZoneOption> {
    public static final String ID = "s2id_timezone";

    public TimeZoneSelector(@Nonnull PageElement container) {
        super(container, TimeZoneOption.class);
    }

    public TimeZoneSelector clearTimeZone() {
        this.openOptions();
        this.clearFilter();
        this.type("Default");
        TimeZoneOption option = (TimeZoneOption)this.findOption(tzOption -> tzOption.getCssClasses().contains("default-option"));
        if (option != null) {
            this.selectOption(option);
        }
        return (TimeZoneSelector)this.self();
    }

    public Optional<ZoneId> getTimeZone() {
        return Optional.ofNullable(StringUtils.stripToNull((String)this.getSelectedOption().getValue())).map(ZoneId::of);
    }

    public TimeZoneSelector filter(String value) {
        ((TimeZoneSelector)this.openOptions()).type(value);
        return (TimeZoneSelector)this.self();
    }

    public TimeZoneSelector setTimeZone(@Nonnull ZoneId zoneId) {
        TimeZoneOption option = this.findOption(zoneId);
        if (option != null) {
            this.selectOption(option);
        }
        return (TimeZoneSelector)this.self();
    }

    @Nullable
    private TimeZoneOption findOption(@Nonnull ZoneId zoneId) {
        return (TimeZoneOption)this.findOption(optionClass -> zoneId.getId().equals(optionClass.getValue()));
    }

    private TimeZoneOption getSelectedOption() {
        return (TimeZoneOption)((Iterable)this.getSelectedOptions().now()).iterator().next();
    }
}

